"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replacedQueries = exports.createDynamicQueries = void 0;
var _lodash = require("lodash");
var _uuid = require("uuid");
var _errors = require("../../../common/translations/errors");
var _replace_params_query = require("../../../common/utils/replace_params_query");
var _utils = require("../../routes/saved_query/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDynamicQueries = async ({
  params,
  alertData,
  agents,
  osqueryContext,
  error,
  spaceId,
  spaceScopedClient
}) => {
  var _params$queries, _osqueryContext$servi;
  return (_params$queries = params.queries) !== null && _params$queries !== void 0 && _params$queries.length ? (0, _lodash.map)(params.queries, ({
    query,
    ...restQuery
  }) => {
    const replacedQuery = replacedQueries(query, alertData);
    return (0, _lodash.pickBy)({
      ...replacedQuery,
      ...restQuery,
      ...(error ? {
        error
      } : {}),
      action_id: (0, _uuid.v4)(),
      alert_ids: params.alert_ids,
      agents
    }, value => !(0, _lodash.isEmpty)(value) || value === true || (0, _lodash.isNumber)(value));
  }) : [(0, _lodash.pickBy)({
    action_id: (0, _uuid.v4)(),
    id: (0, _uuid.v4)(),
    ...replacedQueries(params.query, alertData),
    saved_query_id: params.saved_query_id,
    saved_query_prebuilt: params.saved_query_id ? await (0, _utils.isSavedQueryPrebuilt)((_osqueryContext$servi = osqueryContext.service.getPackageService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser, params.saved_query_id, spaceScopedClient, spaceId) : undefined,
    ecs_mapping: params.ecs_mapping,
    alert_ids: params.alert_ids,
    timeout: params.timeout,
    agents,
    ...(error ? {
      error
    } : {})
  }, value => !(0, _lodash.isEmpty)(value) || (0, _lodash.isNumber)(value))];
};
exports.createDynamicQueries = createDynamicQueries;
const replacedQueries = (query, alertData) => {
  if (alertData && query) {
    const {
      result,
      skipped
    } = (0, _replace_params_query.replaceParamsQuery)(query, alertData);
    return {
      query: result,
      ...(skipped ? {
        error: _errors.PARAMETER_NOT_FOUND
      } : {})
    };
  }
  return {
    query
  };
};
exports.replacedQueries = replacedQueries;