"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAttachment = void 0;
var _tools = require("@kbn/onechat-server/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateAttachment = async ({
  attachment,
  registry
}) => {
  if (!registry.has(attachment.type)) {
    return {
      valid: false,
      error: `Unknown attachment type: ${attachment.type}`
    };
  }
  const typeDefinition = registry.get(attachment.type);
  try {
    const typeValidation = await typeDefinition.validate(attachment.data);
    if (typeValidation.valid) {
      var _attachment$id;
      return {
        valid: true,
        attachment: {
          id: (_attachment$id = attachment.id) !== null && _attachment$id !== void 0 ? _attachment$id : (0, _tools.getToolResultId)(),
          type: attachment.type,
          data: typeValidation.data,
          hidden: attachment.hidden
        }
      };
    } else {
      return {
        valid: false,
        error: typeValidation.error
      };
    }
  } catch (e) {
    return {
      valid: false,
      error: `Error during attachment validation: ${e.message}`
    };
  }
};
exports.validateAttachment = validateAttachment;