"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActionType = void 0;
exports.answerAction = answerAction;
exports.errorAction = errorAction;
exports.executeToolAction = executeToolAction;
exports.handoverAction = handoverAction;
exports.isAgentErrorAction = isAgentErrorAction;
exports.isAnswerAction = isAnswerAction;
exports.isExecuteToolAction = isExecuteToolAction;
exports.isHandoverAction = isHandoverAction;
exports.isToolCallAction = isToolCallAction;
exports.toolCallAction = toolCallAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AgentActionType = exports.AgentActionType = /*#__PURE__*/function (AgentActionType) {
  AgentActionType["Error"] = "error";
  AgentActionType["ToolCall"] = "tool_call";
  AgentActionType["ExecuteTool"] = "execute_tool";
  AgentActionType["HandOver"] = "hand_over";
  AgentActionType["Answer"] = "answer";
  return AgentActionType;
}({}); // research phase actions
// answer phase actions
// all possible actions for the agent flow
// type guards

function isAgentErrorAction(action) {
  return action.type === AgentActionType.Error;
}
function isToolCallAction(action) {
  return action.type === AgentActionType.ToolCall;
}
function isExecuteToolAction(action) {
  return action.type === AgentActionType.ExecuteTool;
}
function isHandoverAction(action) {
  return action.type === AgentActionType.HandOver;
}
function isAnswerAction(action) {
  return action.type === AgentActionType.Answer;
}

// creation helpers

function errorAction(error) {
  return {
    type: AgentActionType.Error,
    error
  };
}
function toolCallAction(toolCalls, message) {
  return {
    type: AgentActionType.ToolCall,
    tool_calls: toolCalls,
    message
  };
}
function executeToolAction(toolResults) {
  return {
    type: AgentActionType.ExecuteTool,
    tool_results: toolResults
  };
}
function handoverAction(message, forceful = false) {
  return {
    type: AgentActionType.HandOver,
    message,
    forceful
  };
}
function answerAction(message) {
  return {
    type: AgentActionType.Answer,
    message
  };
}