"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHandlerWrapper = void 0;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _onechatCommon = require("@kbn/onechat-common");
var _license = require("../../common/license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHandlerWrapper = ({
  logger
}) => (handler, {
  featureFlag = _managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID,
  ignoreLicense = false
} = {}) => {
  return async (ctx, req, res) => {
    if (featureFlag !== false) {
      const {
        uiSettings
      } = await ctx.core;
      const enabled = await uiSettings.client.get(featureFlag);
      if (!enabled) {
        return res.notFound();
      }
    }
    if (!ignoreLicense) {
      const {
        license
      } = await ctx.licensing;
      if (!(0, _license.isValidLicense)(license)) {
        return res.forbidden();
      }
    }
    try {
      return await handler(ctx, req, res);
    } catch (e) {
      if ((0, _onechatCommon.isOnechatError)(e)) {
        var _e$meta, _e$meta$statusCode, _e$meta2;
        logger.error(e);
        return res.customError({
          body: {
            message: e.message,
            attributes: {
              trace_id: (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : _e$meta.traceId
            }
          },
          statusCode: (_e$meta$statusCode = (_e$meta2 = e.meta) === null || _e$meta2 === void 0 ? void 0 : _e$meta2.statusCode) !== null && _e$meta$statusCode !== void 0 ? _e$meta$statusCode : 500
        });
      } else {
        var _e$stack, _e$message;
        logger.error(`Unexpected error in handler: ${(_e$stack = e.stack) !== null && _e$stack !== void 0 ? _e$stack : e.message}`);
        return res.customError({
          body: {
            message: (_e$message = e.message) !== null && _e$message !== void 0 ? _e$message : 'An unexpected error occurred'
          },
          statusCode: 500
        });
      }
    }
  };
};
exports.getHandlerWrapper = getHandlerWrapper;