"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConversationInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _embeddable_conversations_provider = require("../application/context/conversation/embeddable_conversations_provider");
var _conversation = require("../application/components/conversations/conversation");
var _embeddable_conversation_header = require("./embeddable_conversation_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/embeddable_conversation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmbeddableConversationInternal = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onClose,
    ariaLabelledBy
  } = props;
  const backgroundStyles = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
  `;
  const headerStyles = (0, _react2.css)`
    ${backgroundStyles}
    display: flex;
    align-items: center;
    &.euiFlyoutHeader {
      padding-inline: 0;
      padding-block-start: 0;
      padding: ${euiTheme.size.base};
    }
  `;
  const bodyStyles = (0, _react2.css)`
    ${backgroundStyles}
    flex: 1;

    .euiFlyoutBody__overflow {
      overflow: hidden;
      height: 100%;
    }

    .euiFlyoutBody__overflowContent {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      height: 100%;
      overflow: hidden;
      padding: 0;
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_embeddable_conversations_provider.EmbeddableConversationsProvider, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    css: headerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_embeddable_conversation_header.EmbeddableConversationHeader, {
    onClose: onClose,
    ariaLabelledBy: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: bodyStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation.Conversation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })));
};
exports.EmbeddableConversationInternal = EmbeddableConversationInternal;