"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistedConversationId = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _storage_keys = require("../storage_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePersistedConversationId = ({
  sessionTag,
  agentId
}) => {
  const storageKey = _storage_keys.storageKeys.getLastConversationKey(sessionTag, agentId);
  const [persistedConversationId, setPersistedConversationId, clearPersistedConversationId] = (0, _useLocalStorage.default)(storageKey);
  const updatePersistedConversationId = id => {
    if (id) {
      setPersistedConversationId(id);
    } else {
      clearPersistedConversationId();
    }
  };
  return {
    persistedConversationId,
    updatePersistedConversationId
  };
};
exports.usePersistedConversationId = usePersistedConversationId;