"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConversationsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _conversation_context = require("./conversation_context");
var _onechat_services_context = require("../onechat_services_context");
var _send_message_context = require("../send_message/send_message_context");
var _use_conversation_actions = require("./use_conversation_actions");
var _use_persisted_conversation_id = require("../../hooks/use_persisted_conversation_id");
var _get_processed_attachments = require("./get_processed_attachments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/conversation/embeddable_conversations_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmbeddableConversationsProvider = ({
  children,
  coreStart,
  services,
  ...contextProps
}) => {
  // Create a QueryClient per instance to ensure cache isolation between multiple embeddable conversations
  const queryClient = (0, _react.useMemo)(() => new _reactQuery.QueryClient(), []);
  const kibanaServices = (0, _react.useMemo)(() => ({
    ...coreStart,
    plugins: {
      ...services.startDependencies
    }
  }), [coreStart, services.startDependencies]);
  const {
    persistedConversationId,
    updatePersistedConversationId
  } = (0, _use_persisted_conversation_id.usePersistedConversationId)({
    sessionTag: contextProps.sessionTag,
    agentId: contextProps.agentId
  });
  const hasInitializedConversationIdRef = (0, _react.useRef)(false);
  const setConversationId = (0, _react.useCallback)(id => {
    if (id !== persistedConversationId) {
      updatePersistedConversationId(id);
    }
  }, [persistedConversationId, updatePersistedConversationId]);
  const validateAndSetConversationId = (0, _react.useCallback)(async id => {
    try {
      var _conversation$id;
      const conversation = await services.conversationsService.get({
        conversationId: id
      });
      setConversationId((_conversation$id = conversation.id) !== null && _conversation$id !== void 0 ? _conversation$id : undefined);
    } catch {
      setConversationId(undefined);
    }
  }, [services.conversationsService, setConversationId]);

  // One-time initialization per provider instance:
  // - If newConversation flag is set, clears the conversation ID to start fresh.
  // - Otherwise, if there's a persisted conversation ID, validates and restores it.
  // - Otherwise, clears the conversation ID.
  // Guarded by hasInitializedConversationIdRef to prevent re-running on subsequent renders.
  (0, _react.useEffect)(() => {
    if (hasInitializedConversationIdRef.current) return;
    if (contextProps.newConversation) {
      setConversationId(undefined);
    } else if (persistedConversationId) {
      validateAndSetConversationId(persistedConversationId);
    } else {
      setConversationId(undefined);
    }
    hasInitializedConversationIdRef.current = true;
  }, [contextProps.newConversation, persistedConversationId, setConversationId, validateAndSetConversationId]);
  const onConversationCreated = (0, _react.useCallback)(({
    conversationId: id
  }) => {
    setConversationId(id);
  }, [setConversationId]);
  const conversationActions = (0, _use_conversation_actions.useConversationActions)({
    conversationId: persistedConversationId,
    queryClient,
    conversationsService: services.conversationsService,
    onConversationCreated
  });
  const attachmentMapRef = (0, _react.useRef)(new Map());
  const setAttachmentMap = (0, _react.useCallback)(attachments => {
    attachmentMapRef.current = attachments;
  }, []);
  const handleGetProcessedAttachments = (0, _react.useCallback)(_conversation => {
    var _contextProps$attachm;
    return (0, _get_processed_attachments.getProcessedAttachments)({
      attachments: (_contextProps$attachm = contextProps.attachments) !== null && _contextProps$attachm !== void 0 ? _contextProps$attachm : [],
      getAttachment: id => attachmentMapRef.current.get(id),
      setAttachment: (id, content) => attachmentMapRef.current.set(id, content)
    });
  }, [contextProps.attachments]);
  const conversationContextValue = (0, _react.useMemo)(() => ({
    conversationId: persistedConversationId,
    shouldStickToBottom: true,
    isEmbeddedContext: true,
    sessionTag: contextProps.sessionTag,
    agentId: contextProps.agentId,
    initialMessage: contextProps.initialMessage,
    browserApiTools: contextProps.browserApiTools,
    setConversationId,
    attachments: contextProps.attachments,
    conversationActions,
    getProcessedAttachments: handleGetProcessedAttachments,
    setAttachmentMap
  }), [persistedConversationId, contextProps.sessionTag, contextProps.agentId, contextProps.initialMessage, contextProps.attachments, contextProps.browserApiTools, conversationActions, handleGetProcessedAttachments, setConversationId, setAttachmentMap]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: kibanaServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_onechat_services_context.OnechatServicesContext.Provider, {
    value: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_context.ConversationContext.Provider, {
    value: conversationContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_send_message_context.SendMessageProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, children))))));
};
exports.EmbeddableConversationsProvider = EmbeddableConversationsProvider;