"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationActionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _send_message_context = require("../../../context/send_message/send_message_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/conversation_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  cancel: _i18n.i18n.translate('xpack.onechat.conversationInputForm.cancel', {
    defaultMessage: 'Cancel'
  }),
  submit: _i18n.i18n.translate('xpack.onechat.conversationInputForm.submit', {
    defaultMessage: 'Submit'
  })
};
const ConversationActionButton = ({
  onSubmit,
  isSubmitDisabled,
  resetToPendingMessage
}) => {
  const {
    canCancel,
    cancel
  } = (0, _send_message_context.useSendMessage)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cancelButtonStyles = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundLightText};
  `;
  return canCancel ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": labels.cancel,
    "data-test-subj": "onechatAppConversationInputFormCancelButton",
    iconType: "stopFilled",
    size: "m",
    color: "text",
    css: cancelButtonStyles,
    onClick: () => {
      if (canCancel) {
        cancel();
        resetToPendingMessage();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": labels.submit,
    "data-test-subj": "onechatAppConversationInputFormSubmitButton",
    iconType: "sortUp",
    display: "fill",
    size: "m",
    disabled: isSubmitDisabled,
    onClick: onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.ConversationActionButton = ConversationActionButton;