"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _use_conversation = require("../../hooks/use_conversation");
var _conversation_actions = require("./conversation_actions");
var _conversation_sidebar_toggle = require("./conversation_sidebar/conversation_sidebar_toggle");
var _conversation_title = require("./conversation_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConversationHeader = ({
  sidebar
}) => {
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const containerStyles = (0, _react2.css)`
    display: flex;
    flex-direction: row;
    align-items: center;
    width: 100%;
  `;
  const sectionStyles = (0, _react2.css)`
    flex: 1;
    display: flex;
    align-items: center;
  `;
  const leftSectionStyles = (0, _react2.css)`
    ${sectionStyles}
    justify-content: flex-start;
  `;
  const centerSectionStyles = (0, _react2.css)`
    ${sectionStyles}
    justify-content: center;
  `;
  const rightSectionStyles = (0, _react2.css)`
    ${sectionStyles}
    justify-content: flex-end;
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: leftSectionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_sidebar_toggle.ConversationSidebarToggle, {
    isSidebarOpen: sidebar.isOpen,
    onToggle: sidebar.onToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })), hasActiveConversation && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: centerSectionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_title.ConversationTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: rightSectionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_actions.ConversationActions, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }))));
};
exports.ConversationHeader = ConversationHeader;