"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TechPreviewTitle = exports.TechPreviewBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/common/tech_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const techPreviewLabel = _i18n.i18n.translate('xpack.onechat.techPreviewLabel', {
  defaultMessage: 'Tech preview'
});
const badgeAnchorStyles = (0, _react.css)`
  display: flex;
  justify-content: center;
  align-items: center;
`;
const TechPreviewBadge = ({
  iconOnly = false
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
    iconType: iconOnly ? 'flask' : undefined,
    label: techPreviewLabel,
    anchorProps: {
      css: badgeAnchorStyles
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
};
exports.TechPreviewBadge = TechPreviewBadge;
const TechPreviewTitle = ({
  title
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, title, /*#__PURE__*/_react2.default.createElement(TechPreviewBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
exports.TechPreviewTitle = TechPreviewTitle;