"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueSuggestions = FieldValueSuggestions;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_values_list = require("../../hooks/use_values_list");
var _field_value_selection = require("./field_value_selection");
var _field_value_combobox = require("./field_value_combobox");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/field_value_suggestions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldValueSuggestions({
  fullWidth,
  sourceField,
  label,
  dataViewTitle,
  selectedValue,
  excludedValue,
  filters,
  button,
  time,
  width,
  forceOpen,
  setForceOpen,
  anchorPosition,
  singleSelection,
  compressed,
  asFilterButton,
  usePrependLabel,
  allowAllValuesSelection,
  required,
  allowExclusions = true,
  cardinalityField,
  inspector,
  asCombobox = true,
  keepHistory = true,
  showLogicalConditionSwitch,
  useLogicalAND,
  onChange: onSelectionChange
}) {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    values,
    loading
  } = (0, _use_values_list.useValuesList)({
    dataViewTitle,
    query,
    sourceField,
    filters,
    time,
    inspector,
    cardinalityField,
    keepHistory,
    label
  });
  const SelectionComponent = asCombobox ? _field_value_combobox.FieldValueCombobox : _field_value_selection.FieldValueSelection;
  return /*#__PURE__*/_react.default.createElement(SelectionComponent, {
    fullWidth: fullWidth,
    singleSelection: singleSelection,
    values: values,
    label: label,
    onChange: onSelectionChange,
    query: query,
    setQuery: setQuery,
    loading: loading,
    selectedValue: selectedValue,
    excludedValue: excludedValue,
    button: button,
    forceOpen: forceOpen,
    setForceOpen: setForceOpen,
    anchorPosition: anchorPosition,
    width: width,
    compressed: compressed,
    asFilterButton: asFilterButton,
    usePrependLabel: usePrependLabel,
    allowExclusions: allowExclusions,
    allowAllValuesSelection: singleSelection ? false : allowAllValuesSelection,
    required: required,
    showLogicalConditionSwitch: showLogicalConditionSwitch,
    useLogicalAND: useLogicalAND,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = FieldValueSuggestions;