"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseFeatureNoPermissions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _empty_page = require("./empty_page");
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/cases/components/feature_no_permissions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseFeatureNoPermissions = exports.CaseFeatureNoPermissions = /*#__PURE__*/_react.default.memo(() => {
  const {
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const actions = (0, _react.useMemo)(() => ({
    savedObject: {
      icon: 'documents',
      label: _i18n.i18n.translate('xpack.observability.cases.caseView.goToDocumentationButton', {
        defaultMessage: 'View documentation'
      }),
      target: '_blank',
      url: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/security/${docLinks.DOC_LINK_VERSION}s`
    }
  }), [docLinks]);
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: actions,
    "data-test-subj": "noFeaturePermissions",
    message: _i18n.i18n.translate('xpack.observability.cases.caseFeatureNoPermissionsMessage', {
      defaultMessage: 'To view cases, you must have privileges for the Cases feature in the Kibana space. For more information, contact your Kibana administrator.'
    }),
    title: _i18n.i18n.translate('xpack.observability.cases.caseFeatureNoPermissionsTitle', {
      defaultMessage: 'Kibana feature privileges required'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
});
CaseFeatureNoPermissions.displayName = 'CaseSavedObjectNoPermissions';