"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleConditionChart = RuleConditionChart;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _i18n = require("@kbn/i18n");
var _alertingComparators = require("@kbn/alerting-comparators");
var _constants = require("../../../common/constants");
var _kibana_react = require("../../utils/kibana_react");
var _painless_tinymath_parser = require("./painless_tinymath_parser");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/rule_condition_chart/rule_condition_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultQuery = {
  language: 'kuery',
  query: ''
};
const EMPTY_ARRAY = [];
function NonNullable(value) {
  return value != null;
}
function RuleConditionChart({
  metricExpression,
  searchConfiguration,
  dataView,
  groupBy,
  error,
  annotations,
  timeRange,
  chartOptions: {
    seriesType,
    interval
  } = {},
  additionalFilters = EMPTY_ARRAY
}) {
  const {
    services: {
      lens,
      dataViews
    }
  } = (0, _kibana_react.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    metrics,
    timeSize,
    timeUnit,
    threshold,
    comparator,
    equation,
    label,
    warningComparator,
    warningThreshold
  } = metricExpression;
  const [attributes, setAttributes] = (0, _react.useState)();
  const [aggMap, setAggMap] = (0, _react.useState)();
  const [formula, setFormula] = (0, _react.useState)('');
  const [thresholdReferenceLine, setThresholdReferenceLine] = (0, _react.useState)();
  const [warningThresholdReferenceLine, setWarningThresholdReferenceLine] = (0, _react.useState)();
  const [alertAnnotation, setAlertAnnotation] = (0, _react.useState)();
  const [chartLoading, setChartLoading] = (0, _react.useState)(false);
  const filters = (0, _react.useMemo)(() => {
    var _searchConfiguration$;
    return [...((_searchConfiguration$ = searchConfiguration.filter) !== null && _searchConfiguration$ !== void 0 ? _searchConfiguration$ : EMPTY_ARRAY), ...additionalFilters];
  }, [searchConfiguration.filter, additionalFilters]);

  // Handle Lens error
  (0, _react.useEffect)(() => {
    // Lens does not expose or provide a way to check if there is an error in the chart, yet.
    // To work around this, we check if the element with class 'lnsEmbeddedError' is found in the DOM.
    setTimeout(function () {
      const errorDiv = document.querySelector('.lnsEmbeddedError');
      if (errorDiv) {
        const paragraphElements = errorDiv.querySelectorAll('p');
        if (!paragraphElements) return;
        paragraphElements[0].innerText = _i18n.i18n.translate('xpack.observability.ruleCondition.chart.error_equation.title', {
          defaultMessage: 'An error occurred while rendering the chart'
        });
        if (paragraphElements.length > 1) {
          paragraphElements[1].innerText = _i18n.i18n.translate('xpack.observability.ruleCondition.chart.error_equation.description', {
            defaultMessage: 'Check the rule equation.'
          });
        }
      }
    });
  }, [chartLoading, attributes]);

  // Build the warning threshold reference line
  (0, _react.useEffect)(() => {
    if (!warningThreshold) {
      if (warningThresholdReferenceLine !== null && warningThresholdReferenceLine !== void 0 && warningThresholdReferenceLine.length) {
        setWarningThresholdReferenceLine([]);
      }
      return;
    }
    const refLayers = [];
    if (warningComparator === _alertingComparators.COMPARATORS.NOT_BETWEEN || warningComparator === _alertingComparators.COMPARATORS.BETWEEN && warningThreshold.length === 2) {
      const [startFill, endFill] = warningComparator === _alertingComparators.COMPARATORS.NOT_BETWEEN ? ['below', 'above'] : ['above', 'none'];
      const refLayer = {
        type: 'reference',
        yAxis: [{
          value: (warningThreshold[0] || 0).toString(),
          seriesColor: euiTheme.colors.warning,
          fill: startFill
        }, warningComparator === _alertingComparators.COMPARATORS.BETWEEN ? {
          value: (warningThreshold[1] || 0).toString(),
          seriesColor: 'transparent',
          fill: startFill
        } : undefined, {
          value: (warningThreshold[1] || 0).toString(),
          seriesColor: euiTheme.colors.warning,
          fill: endFill
        }].filter(NonNullable)
      };
      refLayers.push(refLayer);
    } else {
      let fill = 'above';
      if (warningComparator === _alertingComparators.COMPARATORS.LESS_THAN || warningComparator === _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS) {
        fill = 'below';
      }
      const warningThresholdRefLine = {
        type: 'reference',
        yAxis: [{
          value: (warningThreshold[0] || 0).toString(),
          seriesColor: euiTheme.colors.warning,
          fill
        }, warningComparator === _alertingComparators.COMPARATORS.LESS_THAN || warningComparator === _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS ?
        // A transparent line to add extra buffer at the top of threshold
        {
          value: (0, _helpers.getBufferThreshold)(warningThreshold[0]),
          seriesColor: 'transparent',
          fill
        } : undefined].filter(NonNullable)
      };
      refLayers.push(warningThresholdRefLine);
    }
    setWarningThresholdReferenceLine(refLayers);
  }, [warningThreshold, warningComparator, euiTheme.colors.warning, metrics, warningThresholdReferenceLine === null || warningThresholdReferenceLine === void 0 ? void 0 : warningThresholdReferenceLine.length]);

  // Build the threshold reference line
  (0, _react.useEffect)(() => {
    if (!threshold) return;
    const refLayers = [];
    if (comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN || comparator === _alertingComparators.COMPARATORS.BETWEEN && threshold.length === 2) {
      const [startFill, endFill] = comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN ? ['below', 'above'] : ['above', 'none'];
      const refLayer = {
        type: 'reference',
        yAxis: [{
          value: (threshold[0] || 0).toString(),
          seriesColor: euiTheme.colors.danger,
          fill: startFill
        }, comparator === _alertingComparators.COMPARATORS.BETWEEN ? {
          value: (threshold[1] || 0).toString(),
          seriesColor: 'transparent',
          fill: startFill
        } : undefined, {
          value: (threshold[1] || 0).toString(),
          seriesColor: euiTheme.colors.danger,
          fill: endFill
        }].filter(NonNullable)
      };
      refLayers.push(refLayer);
    } else {
      let fill = 'above';
      if (comparator === _alertingComparators.COMPARATORS.LESS_THAN || comparator === _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS) {
        fill = 'below';
      }
      const thresholdRefLine = {
        type: 'reference',
        yAxis: [{
          value: (threshold[0] || 0).toString(),
          seriesColor: euiTheme.colors.danger,
          fill
        }, comparator === _alertingComparators.COMPARATORS.LESS_THAN || comparator === _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS ?
        // A transparent line to add extra buffer at the top of threshold
        {
          value: (0, _helpers.getBufferThreshold)(threshold[0]),
          seriesColor: 'transparent',
          fill
        } : undefined].filter(NonNullable)
      };
      refLayers.push(thresholdRefLine);
    }
    setThresholdReferenceLine(refLayers);
  }, [threshold, comparator, euiTheme.colors.danger, metrics]);

  // Build alert annotation
  (0, _react.useEffect)(() => {
    if (!annotations) return;
    function getAnnotationEvent(annotation) {
      if (annotation.key.type === 'range') {
        return;
      }
      if ('timeField' in annotation) {
        var _annotation$filter;
        if (!annotation.timeField) {
          return;
        }
        return {
          name: annotation.label,
          color: annotation.color,
          field: annotation.timeField,
          filter: typeof ((_annotation$filter = annotation.filter) === null || _annotation$filter === void 0 ? void 0 : _annotation$filter.query) === 'string' ? annotation.filter.query : ''
        };
      }
      if ('timestamp' in annotation.key && annotation.key.timestamp) {
        return {
          name: annotation.label,
          color: annotation.color,
          datetime: annotation.key.timestamp
        };
      }
      return;
    }
    function isNonNullable(value) {
      return value != null;
    }
    const alertAnnotationLayer = {
      type: 'annotation',
      events: annotations.map(getAnnotationEvent).filter(isNonNullable),
      yAxis: []
    };
    setAlertAnnotation(alertAnnotationLayer);
  }, [annotations]);

  // Build the aggregation map from the metrics
  (0, _react.useEffect)(() => {
    if (!metrics || metrics.length === 0) {
      return;
    }
    const aggMapFromMetrics = metrics.reduce((acc, metric) => {
      const {
        operation,
        operationWithField,
        sourceField
      } = (0, _helpers.getLensOperationFromRuleMetric)(metric);
      return {
        ...acc,
        [metric.name]: {
          operation,
          operationWithField,
          sourceField
        }
      };
    }, {});
    setAggMap(aggMapFromMetrics);
  }, [metrics]);

  // Parse the equation
  (0, _react.useEffect)(() => {
    try {
      if (!aggMap) return;
      const parser = new _painless_tinymath_parser.PainlessTinyMathParser({
        aggMap,
        equation: equation || Object.keys(aggMap || {}).join(' + ')
      });
      setFormula(parser.parse());
    } catch (e) {
      // The error will appear on Lens chart.
      setAttributes(undefined);
      return;
    }
  }, [aggMap, equation]);
  (0, _useAsync.default)(async () => {
    var _dataView$timeFieldNa, _dataView$id;
    if (!dataView || !formula) {
      return;
    }
    const formatId = (0, _helpers.lensFieldFormatter)(metrics);
    const baseLayer = {
      type: 'formula',
      value: formula,
      label: label !== null && label !== void 0 ? label : formula,
      groupBy,
      format: {
        id: formatId,
        params: {
          decimals: formatId === _helpers.LensFieldFormat.PERCENT ? 0 : 2,
          suffix: (0, _helpers.isRate)(metrics) && formatId === _helpers.LensFieldFormat.NUMBER ? _constants.EventsAsUnit : undefined
        }
      }
    };
    const xYDataLayerOptions = {
      type: 'series',
      xAxis: {
        type: 'dateHistogram',
        field: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '@timestamp',
        minimumInterval: interval || `${timeSize}${timeUnit}`
      },
      seriesType: (seriesType !== null && seriesType !== void 0 ? seriesType : 'bar').split('_')[0],
      yAxis: [baseLayer].map(({
        type,
        value,
        label: layerLabel,
        format
      }) => {
        var _format$params, _format$params2;
        return {
          type,
          value,
          label: layerLabel,
          format: format.id,
          decimals: (_format$params = format.params) === null || _format$params === void 0 ? void 0 : _format$params.decimals,
          suffix: (_format$params2 = format.params) === null || _format$params2 === void 0 ? void 0 : _format$params2.suffix,
          // We always scale the chart with seconds with RATE Agg.
          timeScale: (0, _helpers.isRate)(metrics) ? 's' : undefined
        };
      })
    };
    const firstMetricAggMap = aggMap && metrics.length > 0 ? aggMap[metrics[0].name] : undefined;
    const convertToMaxOperation = ['counter_rate', 'last_value', 'percentile'];
    const orderParams = firstMetricAggMap ? {
      orderDirection: 'desc',
      orderBy: {
        type: 'custom'
      },
      orderAgg: {
        label: firstMetricAggMap.operationWithField,
        dataType: 'number',
        operationType: convertToMaxOperation.includes(firstMetricAggMap.operation) ? 'max' : firstMetricAggMap.operation,
        sourceField: firstMetricAggMap.sourceField,
        isBucketed: false,
        scale: 'ratio'
      }
    } : undefined;
    if (groupBy && groupBy !== null && groupBy !== void 0 && groupBy.length) {
      xYDataLayerOptions.breakdown = {
        type: 'topValues',
        field: groupBy[0],
        size: 3,
        orderBy: orderParams
      };
    }
    const layers = [xYDataLayerOptions];
    if (warningThresholdReferenceLine) {
      layers.push(...warningThresholdReferenceLine);
    }
    if (thresholdReferenceLine) {
      layers.push(...thresholdReferenceLine);
    }
    if (alertAnnotation) {
      layers.push(alertAnnotation);
    }
    const lensBuilder = new _lensEmbeddableUtils.LensConfigBuilder(dataViews);
    const attributesLens = await lensBuilder.build({
      dataset: {
        index: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : dataView.getIndexPattern(),
        timeFieldName: dataView.timeFieldName
      },
      chartType: 'xy',
      title: '',
      layers,
      axisTitleVisibility: {
        showXAxisTitle: true,
        showYAxisTitle: false,
        showYRightAxisTitle: true
      },
      valueLabels: 'hide'
    }, {
      query: searchConfiguration.query,
      filters,
      timeRange: {
        type: 'absolute',
        from: timeRange.from,
        to: timeRange.to
      }
    });
    const lensBuilderAtt = {
      ...attributesLens,
      type: 'lens'
    };
    setAttributes(lensBuilderAtt);
  }, [dataView, metrics, formula, label, groupBy, interval, timeSize, timeUnit, seriesType, aggMap, warningThresholdReferenceLine, thresholdReferenceLine, alertAnnotation, searchConfiguration.query, filters, timeRange.from, timeRange.to, dataViews]);
  if (!dataView || !attributes || error !== null && error !== void 0 && error.equation || Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || (error === null || error === void 0 ? void 0 : error.metric) || {}).length !== 0 || !timeSize || !timeRange) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxHeight: 180,
        minHeight: 180
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 524,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      titleSize: "xxs",
      "data-test-subj": "thresholdRuleNoChartData",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.charts.noData.title",
        defaultMessage: "No chart data available, check the rule {errorSourceField}",
        values: {
          errorSourceField: Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || {}).length !== 0 ? 'aggregation fields' : error !== null && error !== void 0 && error.equation ? 'equation' : 'conditions'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 530,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    onLoad: setChartLoading,
    id: "ruleConditionChart",
    style: {
      height: 180
    },
    timeRange: timeRange,
    attributes: attributes,
    disableTriggers: true,
    query: searchConfiguration.query || defaultQuery,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 7
    }
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = RuleConditionChart;