"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelLogsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/logs-shared-plugin/common");
var _ebtTools = require("@kbn/ebt-tools");
var _pricing_features = require("../../../../common/pricing_features");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _multi_integration_install_banner = require("./multi_integration_install_banner");
var _empty_prompt = require("../shared/empty_prompt");
var _feedback_buttons = require("../shared/feedback_buttons");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _build_install_command = require("./build_install_command");
var _use_managed_otlp_service_availability = require("../../shared/use_managed_otlp_service_availability");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/otel_logs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HOST_COMMAND = _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.p.runTheCommandOnYourHostLabel', {
  defaultMessage: 'Run the following command on your host to download and configure the collector.'
});
const OtelLogsPanel = () => {
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.breadcrumbs.otelHost', {
      defaultMessage: 'OpenTelemetry: Logs & Metrics'
    })
  });
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    services: {
      share,
      http
    }
  } = (0, _public.useKibana)();
  const {
    data: setupData,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('POST /internal/observability_onboarding/otel_host/setup');
  }, [], {
    showToastOnError: false
  });
  (0, _react.useEffect)(() => {
    if (setupData) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Requests to setup the flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [onPageReady, setupData]);
  const isMetricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const isManagedOtlpServiceAvailable = (0, _use_managed_otlp_service_availability.useManagedOtlpServiceAvailability)();
  const logsLocator = share.url.locators.get(_common.LOGS_LOCATOR_ID);
  const hostsLocator = share.url.locators.get('HOSTS_LOCATOR');
  const [{
    value: deeplinks
  }, getDeeplinks] = (0, _useAsyncFn.default)(async () => {
    return {
      logs: logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({}),
      metrics: hostsLocator === null || hostsLocator === void 0 ? void 0 : hostsLocator.getRedirectUrl({})
    };
  }, [logsLocator]);
  (0, _react.useEffect)(() => {
    getDeeplinks();
  }, [getDeeplinks]);
  const installTabContents = [{
    id: 'linux',
    name: 'Linux',
    firstStepTitle: HOST_COMMAND,
    content: setupData ? (0, _build_install_command.buildInstallCommand)({
      platform: 'linux',
      isMetricsOnboardingEnabled,
      isManagedOtlpServiceAvailable,
      managedOtlpServiceUrl: setupData.managedOtlpServiceUrl,
      elasticsearchUrl: setupData.elasticsearchUrl,
      apiKeyEncoded: setupData.apiKeyEncoded,
      agentVersion: setupData.elasticAgentVersionInfo.agentVersion
    }) : '',
    start: 'sudo ./otelcol --config otel.yml',
    type: 'copy'
  }, {
    id: 'mac',
    name: 'Mac',
    firstStepTitle: HOST_COMMAND,
    content: setupData ? (0, _build_install_command.buildInstallCommand)({
      platform: 'mac',
      isMetricsOnboardingEnabled,
      isManagedOtlpServiceAvailable,
      managedOtlpServiceUrl: setupData.managedOtlpServiceUrl,
      elasticsearchUrl: setupData.elasticsearchUrl,
      apiKeyEncoded: setupData.apiKeyEncoded,
      agentVersion: setupData.elasticAgentVersionInfo.agentVersion
    }) : '',
    start: './otelcol --config otel.yml',
    type: 'copy'
  }];
  const [selectedTab, setSelectedTab] = _react.default.useState(installTabContents[0].id);
  const selectedContent = installTabContents.find(tab => tab.id === selectedTab);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "otel_logs",
      error: error,
      onRetryClick: refetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_integration_install_banner.MultiIntegrationInstallBanner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.platform', {
        defaultMessage: 'Select your platform'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        legend: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.choosePlatform', {
          defaultMessage: 'Choose platform'
        }),
        options: installTabContents.map(({
          id,
          name
        }) => ({
          id,
          label: name
        })),
        type: "single",
        idSelected: selectedTab,
        onChange: id => {
          setSelectedTab(id);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 19
        }
      }), !setupData && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 34
        }
      }), setupData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 25
        }
      }, selectedContent.firstStepTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "sh",
        isCopyable: true,
        overflowHeight: 300,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 25
        }
      }, selectedContent.content)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        align: "left",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: selectedContent.content,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 27
        }
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "observabilityOnboardingOtelLogsPanelButton",
        iconType: "copyClipboard",
        onClick: copy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 31
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.installOtelCollector.configStep.copyCommand', {
        defaultMessage: 'Copy to clipboard'
      })))))))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.start', {
        defaultMessage: 'Start the collector'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.limitationTitle', {
          defaultMessage: 'Configuration Information'
        }),
        color: "warning",
        iconType: "info",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.historicalDataDescription', {
        defaultMessage: 'New log messages are collected from the setup onward.'
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.historicalDataDescription2', {
        defaultMessage: 'The default log path is /var/log/*. You can change this path in the otel.yml file if needed.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.p.startTheCollectorLabel', {
        defaultMessage: 'Run the following command to start the collector'
      }))), /*#__PURE__*/_react.default.createElement(CopyableCodeBlock, {
        content: selectedContent.start,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 19
        }
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.visualize', {
        defaultMessage: 'Visualize your data'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.waitForTheDataLabel', {
        defaultMessage: 'After running the previous command, come back and view your data.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        src: http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref('waterfall_screen.svg'),
        width: 160,
        alt: "Illustration",
        hasShadow: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 23
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        justifyContent: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 23
        }
      }, (deeplinks === null || deeplinks === void 0 ? void 0 : deeplinks.logs) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 31
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.viewAndAnalyzeYourTextLabel', {
        defaultMessage: 'View and analyze your logs'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "obltOnboardingExploreLogs",
        href: deeplinks.logs,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 31
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.exploreLogs', {
        defaultMessage: 'Explore logs'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 25
        }
      }), isMetricsOnboardingEnabled && (deeplinks === null || deeplinks === void 0 ? void 0 : deeplinks.metrics) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 31
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.viewAndAnalyzeYourMetricsTextLabel', {
        defaultMessage: 'View and analyze your metrics'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "obltOnboardingExploreMetrics",
        href: deeplinks.metrics,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 333,
          columnNumber: 31
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.exploreMetrics', {
        defaultMessage: 'Open Hosts'
      }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelLogsPanel.troubleshooting",
        defaultMessage: "Find more details and troubleshooting solution in our documentation. {link}",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "observabilityOnboardingOtelLogsPanelDocumentationLink",
            href: "https://ela.st/elastic-otel",
            target: "_blank",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 357,
              columnNumber: 27
            }
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.documentationLink', {
            defaultMessage: 'Open documentation'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 21
        }
      })))
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "otel_logs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  })));
};
exports.OtelLogsPanel = OtelLogsPanel;
function CopyableCodeBlock({
  content
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 7
    }
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: content,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 7
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityOnboardingCopyableCodeBlockCopyToClipboardButton",
    iconType: "copyClipboard",
    onClick: copy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.installOtelCollector.configStep.copyCommand', {
    defaultMessage: 'Copy to clipboard'
  }))));
}