"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toISOString = toISOString;
exports.toMilliseconds = toMilliseconds;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// converts microseconds to milliseconds
function toMilliseconds(us) {
  if (us) {
    return us / 1000;
  }
}

// convert epoch milliseconds to ISO string
function toISOString(epoch) {
  if (epoch) {
    return new Date(epoch).toISOString();
  }
}