"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OBSERVABILITY_GET_DATA_SOURCES_TOOL_ID = void 0;
exports.createGetDataSourcesTool = createGetDataSourcesTool;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _get_observability_data_sources = require("../../utils/get_observability_data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_GET_DATA_SOURCES_TOOL_ID = exports.OBSERVABILITY_GET_DATA_SOURCES_TOOL_ID = 'observability.get_data_sources';
const getDataSourcesSchema = _zod.z.object({});
function createGetDataSourcesTool({
  core,
  plugins,
  logger
}) {
  const toolDefinition = {
    id: OBSERVABILITY_GET_DATA_SOURCES_TOOL_ID,
    type: _onechatCommon.ToolType.builtin,
    description: 'Retrieve information about where observability data (logs, metrics, traces, alerts) is stored in Elasticsearch. Use this tool to discover which indices or index patterns to query for different types of observability signals.',
    schema: getDataSourcesSchema,
    tags: ['observability'],
    handler: async () => {
      try {
        const {
          apmIndexPatterns: apmIndices,
          logIndexPatterns,
          metricIndexPatterns,
          alertsIndexPattern
        } = await (0, _get_observability_data_sources.getObservabilityDataSources)({
          core,
          plugins,
          logger
        });
        return {
          results: [{
            type: _tool_result.ToolResultType.other,
            data: {
              apm: {
                indexPatterns: apmIndices
              },
              logs: {
                indexPatterns: logIndexPatterns
              },
              metrics: {
                indexPatterns: metricIndexPatterns
              },
              alerts: {
                indexPattern: alertsIndexPattern
              }
            }
          }]
        };
      } catch (error) {
        logger.error(`Error getting observability data sources: ${error.message}`);
        logger.debug(error);
        return {
          results: [{
            type: _tool_result.ToolResultType.error,
            data: {
              message: `Failed to retrieve observability data sources: ${error.message}`,
              stack: error.stack
            }
          }]
        };
      }
    }
  };
  return toolDefinition;
}