"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAgentPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_observability_agent = require("./agent/register_observability_agent");
var _register_tools = require("./tools/register_tools");
var _get_is_obs_agent_enabled = require("./utils/get_is_obs_agent_enabled");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAgentPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    (0, _get_is_obs_agent_enabled.getIsObservabilityAgentEnabled)(core).then(isObservabilityAgentEnabled => {
      if (!isObservabilityAgentEnabled) {
        this.logger.debug(`Skipping observability agent registration because feature flag "${_constants.OBSERVABILITY_AGENT_FEATURE_FLAG}" is set to false`);
        return;
      }
      (0, _register_tools.registerTools)({
        core,
        plugins,
        logger: this.logger
      }).catch(error => {
        this.logger.error(`Error registering observability agent tools: ${error}`);
      });
      (0, _register_observability_agent.registerObservabilityAgent)({
        core,
        plugins,
        logger: this.logger
      }).catch(error => {
        this.logger.error(`Error registering observability agent: ${error}`);
      });
    }).catch(error => {
      this.logger.error(`Error checking whether the observability agent is enabled: ${error}`);
    });
    return {};
  }
  start(_core, _plugins) {
    return {};
  }
  stop() {}
}
exports.ObservabilityAgentPlugin = ObservabilityAgentPlugin;