"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = TopNavMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _top_nav_menu_items = require("./top_nav_menu_items");
var _top_nav_menu_badges = require("./top_nav_menu_badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu/top_nav_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/

function TopNavMenu(props) {
  const {
    config,
    badges,
    showSearchBar,
    gutterSize,
    ...searchBarProps
  } = props;
  if ((!config || config.length === 0) && (!showSearchBar || !props.unifiedSearch)) {
    return null;
  }
  function renderBadges() {
    return /*#__PURE__*/_react2.default.createElement(_top_nav_menu_badges.TopNavMenuBadges, {
      badges: badges,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 12
      }
    });
  }
  function renderMenu() {
    return /*#__PURE__*/_react2.default.createElement(_top_nav_menu_items.TopNavMenuItems, {
      config: config,
      className: props.className,
      "data-test-subj": "kbn-top-nav-menu-wrapper",
      css: (0, _react.css)`
          button:last-child {
            margin-right: 0;
          }
        `,
      popoverBreakpoints: props.popoverBreakpoints,
      gutterSize: gutterSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
  }
  function renderSearchBar() {
    // Validate presence of all required fields
    if (!showSearchBar || !props.unifiedSearch) return null;
    const {
      AggregateQuerySearchBar
    } = props.unifiedSearch.ui;
    return /*#__PURE__*/_react2.default.createElement(AggregateQuerySearchBar, (0, _extends2.default)({}, searchBarProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 12
      }
    }));
  }
  function renderLayout() {
    const {
      setMenuMountPoint,
      visible
    } = props;
    const styles = {
      badgeWrapper: (0, _react.css)`
        display: flex;
        align-items: center;
      `,
      hidden: (0, _react.css)`
        display: none;
      `
    };
    if (setMenuMountPoint) {
      const badgesEl = renderBadges();
      const menuEl = renderMenu();
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (badgesEl || menuEl) && /*#__PURE__*/_react2.default.createElement(_reactKibanaMount.MountPointPortal, {
        setMountPoint: setMenuMountPoint,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement("span", {
        className: "kbnTopNavMenu__wrapper",
        css: [styles.badgeWrapper, visible === false && styles.hidden],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 15
        }
      }, badgesEl, menuEl)), renderSearchBar());
    } else {
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("span", {
        css: [visible === false && styles.hidden],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 11
        }
      }, renderMenu()), renderSearchBar());
    }
  }
  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};