"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmServerInstances = ApmServerInstances;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _table = require("../../table");
var _status = require("./status");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _listing_callout = require("../../setup_mode/listing_callout");
var _badge = require("../../setup_mode/badge");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/apm/instances/instances.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getColumns(setupMode, cgroup) {
  const memoryField = cgroup ? {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.cgroupMemoryUsageTitle', {
      defaultMessage: 'Memory Usage (cgroup)'
    }),
    field: 'cgroup_memory',
    render: value => (0, _format_number.formatMetric)(value, 'byte')
  } : {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.allocatedMemoryTitle', {
      defaultMessage: 'Allocated Memory'
    }),
    field: 'memory',
    render: value => (0, _format_number.formatMetric)(value, 'byte')
  };
  return [{
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.nameTitle', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    render: (name, apm) => {
      let setupModeStatus = null;
      if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
        const list = (0, _lodash.get)(setupMode, 'data.byUuid', {});
        const status = list[apm.uuid] || {};
        const instance = {
          uuid: apm.uuid,
          name: apm.name
        };
        setupModeStatus = /*#__PURE__*/_react.default.createElement(_badge.SetupModeBadge, {
          setupMode: setupMode,
          status: status,
          instance: instance,
          productName: _constants.APM_SYSTEM_ID,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 13
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/apm/instances/${apm.uuid}`),
        "data-test-subj": `apmLink-${name}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 13
        }
      }, name), setupModeStatus);
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.outputEnabledTitle', {
      defaultMessage: 'Output Enabled'
    }),
    field: 'output'
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.totalEventsRateTitle', {
      defaultMessage: 'Total Events Rate'
    }),
    field: 'total_events_rate',
    render: value => (0, _format_number.formatMetric)(value, '', '/s')
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.bytesSentRateTitle', {
      defaultMessage: 'Bytes Sent Rate'
    }),
    field: 'bytes_sent_rate',
    render: value => (0, _format_number.formatMetric)(value, 'byte', '/s')
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.outputErrorsTitle', {
      defaultMessage: 'Output Errors'
    }),
    field: 'errors',
    render: value => (0, _format_number.formatMetric)(value, '0')
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.lastEventTitle', {
      defaultMessage: 'Last Event'
    }),
    field: 'time_of_last_event',
    render: value => _i18n.i18n.translate('xpack.monitoring.apm.instances.lastEventValue', {
      defaultMessage: '{timeOfLastEvent} ago',
      values: {
        timeOfLastEvent: (0, _common.formatTimestampToDuration)(+(0, _moment.default)(value), 'since')
      }
    })
  }, memoryField, {
    name: _i18n.i18n.translate('xpack.monitoring.apm.instances.versionTitle', {
      defaultMessage: 'Version'
    }),
    field: 'version'
  }];
}
function ApmServerInstances({
  apms,
  setupMode,
  alerts
}) {
  const {
    pagination,
    sorting,
    onTableChange,
    data
  } = apms;
  let setupModeCallout = null;
  if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    setupModeCallout = /*#__PURE__*/_react.default.createElement(_listing_callout.ListingCallOut, {
      setupModeData: setupMode.data,
      productName: _constants.APM_SYSTEM_ID,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 7
      }
    });
  }
  const versions = (0, _lodash.uniq)(data.apms.map(item => item.version)).map(version => {
    return {
      value: version
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.apm.instances.heading",
    defaultMessage: "APM Instances",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status.Status, {
    stats: data.stats,
    alerts: alerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, setupModeCallout, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "apmInstancesTable",
    rows: data.apms,
    columns: getColumns(setupMode, data.cgroup),
    sorting: sorting,
    pagination: pagination,
    setupMode: setupMode,
    productName: _constants.APM_SYSTEM_ID,
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.apm.instances.filterInstancesPlaceholder', {
          defaultMessage: 'Filter Instances…'
        })
      },
      filters: [{
        type: 'field_value_selection',
        field: 'version',
        name: _i18n.i18n.translate('xpack.monitoring.apm.instances.versionFilter', {
          defaultMessage: 'Version'
        }),
        options: versions,
        multiSelect: 'or'
      }]
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }))));
}