"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleMetricViewerEmbeddableUserInputSchema = exports.singleMetricViewerEmbeddableStateSchema = exports.singleMetricViewerEmbeddableInputSchema = exports.singleMetricViewerEmbeddableCustomInputSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _dataServiceServer = require("@kbn/data-service-server");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
var _schemas = require("@kbn/ml-anomaly-utils/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseUserInputProps = _configSchema.schema.object({
  forecastId: _configSchema.schema.maybe(_configSchema.schema.string()),
  functionDescription: _configSchema.schema.maybe(_configSchema.schema.string()),
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  selectedDetectorIndex: _configSchema.schema.number(),
  selectedEntities: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_schemas.mlEntityFieldValueSchema)))
});
const singleMetricViewerEmbeddableUserInputSchema = exports.singleMetricViewerEmbeddableUserInputSchema = _configSchema.schema.object({
  ...baseUserInputProps.getPropSchemas(),
  panelTitle: _configSchema.schema.maybe(_configSchema.schema.string())
});
const singleMetricViewerEmbeddableCustomInputSchema = exports.singleMetricViewerEmbeddableCustomInputSchema = _configSchema.schema.object({
  ...baseUserInputProps.getPropSchemas(),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_esQueryServer.storedFilterSchema)),
  query: _configSchema.schema.maybe(_esQueryServer.querySchema),
  refreshConfig: _configSchema.schema.maybe(_dataServiceServer.refreshIntervalSchema),
  timeRange: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema)
});
const singleMetricViewerEmbeddableInputSchema = exports.singleMetricViewerEmbeddableInputSchema = _configSchema.schema.object({
  ...singleMetricViewerEmbeddableCustomInputSchema.getPropSchemas(),
  title: _configSchema.schema.maybe(_configSchema.schema.string())
});
const singleMetricViewerEmbeddableStateSchema = exports.singleMetricViewerEmbeddableStateSchema = _configSchema.schema.object({
  ..._presentationPublishingSchemas.serializedTitlesSchema.getPropSchemas(),
  ...singleMetricViewerEmbeddableCustomInputSchema.getPropSchemas()
});