"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGEMENT_SECTION_IDS = exports.MANAGEMENT_SECTIONS = void 0;
exports.registerManagementSections = registerManagementSections;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MANAGEMENT_SECTION_IDS = exports.MANAGEMENT_SECTION_IDS = /*#__PURE__*/function (MANAGEMENT_SECTION_IDS) {
  MANAGEMENT_SECTION_IDS["OVERVIEW"] = "overview";
  MANAGEMENT_SECTION_IDS["ANOMALY_DETECTION"] = "anomaly_detection";
  MANAGEMENT_SECTION_IDS["ANALYTICS"] = "analytics";
  MANAGEMENT_SECTION_IDS["TRAINED_MODELS"] = "trained_models";
  MANAGEMENT_SECTION_IDS["AD_SETTINGS"] = "ad_settings";
  return MANAGEMENT_SECTION_IDS;
}({});
const MANAGED_SECTIONS_SERVERLESS_CHECK = {
  [MANAGEMENT_SECTION_IDS.OVERVIEW]: (mlFeatures, isServerless, mlCapabilities) => {
    const isEsProject = !mlFeatures.ad && !mlFeatures.dfa && mlFeatures.nlp;
    if (isEsProject) return true;
    return (
      // Can see Memory Usage & Notifications
      mlCapabilities.canViewMlNodes || mlFeatures.nlp && mlCapabilities.canGetTrainedModels || mlFeatures.dfa && mlCapabilities.canGetDataFrameAnalytics || mlFeatures.ad && mlCapabilities.canGetJobs
    );
  },
  [MANAGEMENT_SECTION_IDS.ANOMALY_DETECTION]: (mlFeatures, isServerless, mlCapabilities) => {
    return mlFeatures.ad && mlCapabilities.isADEnabled && mlCapabilities.canGetJobs;
  },
  [MANAGEMENT_SECTION_IDS.ANALYTICS]: (mlFeatures, isServerless, mlCapabilities) => {
    const isEsProject = !mlFeatures.ad && !mlFeatures.dfa && mlFeatures.nlp;
    if (isEsProject) return false;
    return mlFeatures.dfa && mlCapabilities.isDFAEnabled && mlCapabilities.canGetDataFrameAnalytics;
  },
  [MANAGEMENT_SECTION_IDS.TRAINED_MODELS]: (mlFeatures, isServerless, mlCapabilities) => {
    const isEsProject = isServerless && !mlFeatures.ad && !mlFeatures.dfa && mlFeatures.nlp;
    if (isEsProject) return true;
    return (mlFeatures.nlp || mlFeatures.dfa) && mlCapabilities.canGetTrainedModels;
  },
  [MANAGEMENT_SECTION_IDS.AD_SETTINGS]: (mlFeatures, isServerless, mlCapabilities) => {
    return mlFeatures.ad && mlCapabilities.isADEnabled && mlCapabilities.canGetJobs;
  }
};
const MANAGEMENT_SECTIONS = exports.MANAGEMENT_SECTIONS = {
  [MANAGEMENT_SECTION_IDS.OVERVIEW]: _i18n.i18n.translate('xpack.ml.management.overviewTitle', {
    defaultMessage: 'Overview'
  }),
  [MANAGEMENT_SECTION_IDS.ANOMALY_DETECTION]: _i18n.i18n.translate('xpack.ml.management.anomalyDetectionJobsTitle', {
    defaultMessage: 'Anomaly Detection Jobs'
  }),
  [MANAGEMENT_SECTION_IDS.ANALYTICS]: _i18n.i18n.translate('xpack.ml.management.dataFrameAnalyticsJobsTitle', {
    defaultMessage: 'Data Frame Analytics Jobs'
  }),
  [MANAGEMENT_SECTION_IDS.TRAINED_MODELS]: _i18n.i18n.translate('xpack.ml.management.trainedModelsTitle', {
    defaultMessage: 'Trained Models'
  }),
  [MANAGEMENT_SECTION_IDS.AD_SETTINGS]: _i18n.i18n.translate('xpack.ml.management.settingsTitle', {
    defaultMessage: 'Anomaly Detection Settings'
  })
};
function registerManagementSections(management, core, deps, isServerless, mlFeatures, nlpSettings, experimentalFeatures, mlCapabilities) {
  Object.keys(MANAGEMENT_SECTIONS).forEach(id => {
    const checkPermissionFn = MANAGED_SECTIONS_SERVERLESS_CHECK[id];
    if (!checkPermissionFn) {
      throw new Error(`Unable to check permission for ML management section ${id}`);
    }
    const shouldShowSection = checkPermissionFn(mlFeatures, isServerless, mlCapabilities);
    if (!shouldShowSection) return;
    const sectionId = id;
    const sectionTitle = MANAGEMENT_SECTIONS[sectionId];
    management.sections.section.machineLearning.registerApp({
      id: sectionId,
      title: sectionTitle,
      order: 1,
      async mount(params) {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          chrome: {
            docTitle
          }
        } = coreStart;
        docTitle.change(sectionTitle);
        const mlDeps = {
          cases: pluginsStart.cases,
          charts: pluginsStart.charts,
          contentManagement: pluginsStart.contentManagement,
          dashboard: pluginsStart.dashboard,
          data: pluginsStart.data,
          dataViewEditor: pluginsStart.dataViewEditor,
          dataVisualizer: pluginsStart.dataVisualizer,
          fieldFormats: pluginsStart.fieldFormats,
          lens: pluginsStart.lens,
          licensing: pluginsStart.licensing,
          maps: pluginsStart.maps,
          observabilityAIAssistant: pluginsStart.observabilityAIAssistant,
          presentationUtil: pluginsStart.presentationUtil,
          savedObjectsManagement: pluginsStart.savedObjectsManagement,
          savedSearch: pluginsStart.savedSearch,
          security: pluginsStart.security,
          share: pluginsStart.share,
          triggersActionsUi: pluginsStart.triggersActionsUi,
          uiActions: pluginsStart.uiActions,
          unifiedSearch: pluginsStart.unifiedSearch,
          spaces: pluginsStart.spaces,
          ...deps
        };
        const {
          mountApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./mount_management_app')));
        const unmountAppCallback = await mountApp(core, params, mlDeps, isServerless, mlFeatures, experimentalFeatures, nlpSettings, sectionId);
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      },
      hideFromSidebar: sectionId === MANAGEMENT_SECTION_IDS.AD_SETTINGS
    }).enable();
  });
}