"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/detector_title/detector_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DetectorTitle = ({
  index,
  agg,
  field,
  byField,
  deleteDetector,
  children
}) => {
  const splitField = children === false && byField !== undefined ? byField.field : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontSize: 'small'
    },
    "data-test-subj": "mlDetectorTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, getTitle(agg, field, splitField))), children !== false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%',
      maxWidth: '400px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, deleteDetector !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: 'danger',
    onClick: () => deleteDetector(index),
    iconType: "cross",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.nextButtonAriaLabel', {
      defaultMessage: 'Next'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  })));
};
exports.DetectorTitle = DetectorTitle;
function getTitle(agg, field, splitField) {
  const title = `${agg.title}(${field.name})`;
  if (splitField === null) {
    return title;
  } else {
    return _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.detectorTitle.placeholder', {
      defaultMessage: '{title} split by {field}',
      values: {
        title,
        field: splitField.name
      }
    });
  }
}