"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetJobModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_focus_restoration = require("../../../../util/create_focus_restoration");
var _utils = require("../utils");
var _jobs_list = require("../../../../../../common/constants/jobs_list");
var _kibana = require("../../../../contexts/kibana");
var _open_jobs_warning_callout = require("./open_jobs_warning_callout");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/reset_job_modal/reset_job_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResetJobModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const [resetting, setResetting] = (0, _react.useState)(false);
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [jobIds, setJobIds] = (0, _react.useState)([]);
  const [jobs, setJobs] = (0, _react.useState)([]);
  const [hasManagedJob, setHasManagedJob] = (0, _react.useState)(false);
  const [deleteUserAnnotations, setDeleteUserAnnotations] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(tempJobs => {
    setJobIds(tempJobs.map(({
      id
    }) => id));
    setJobs(tempJobs);
    setHasManagedJob(tempJobs.some(j => (0, _jobs_utils.isManagedJob)(j)));
    setModalVisible(true);
    setResetting(false);
    setDeleteUserAnnotations(false);
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    // This is a workaround to fix the issue where the focus is not returned to the action button when the modal is closed
    if (jobIds.length === 1) {
      (0, _create_focus_restoration.createJobActionFocusRestoration)(jobIds[0])();
    }
  }, [jobIds]);
  const resetJob = (0, _react.useCallback)(async () => {
    setResetting(true);
    await (0, _utils.resetJobs)(toasts, mlApi, jobIds, deleteUserAnnotations);
    closeModal();
    setTimeout(() => {
      refreshJobs();
    }, _jobs_list.RESETTING_JOBS_REFRESH_INTERVAL_MS);
  }, [closeModal, deleteUserAnnotations, jobIds, mlApi, refreshJobs, toasts]);
  if (modalVisible === false || jobIds.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "mlResetJobConfirmModal",
    onClose: closeModal,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetJobsTitle",
    defaultMessage: "Reset {jobsCount, plural, one {{jobId}} other {# jobs}}?",
    values: {
      jobsCount: jobIds.length,
      jobId: jobIds[0]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_open_jobs_warning_callout.OpenJobsWarningCallout, {
    jobs: jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), hasManagedJob === true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
    jobsCount: jobIds.length,
    action: _i18n.i18n.translate('xpack.ml.jobsList.startDatafeedsModal.resetManagedDatafeedsDescription', {
      defaultMessage: 'resetting'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetMultipleJobsDescription",
    defaultMessage: "Resetting {jobsCount, plural, one {a job} other {multiple jobs}} can be time consuming. {jobsCount, plural, one {It} other {They}} will be reset in the background and may not be updated in the jobs list instantly.",
    values: {
      jobsCount: jobIds.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ml.jobsList.resetJobModal.deleteUserAnnotations', {
      defaultMessage: 'Delete annotations'
    }),
    checked: deleteUserAnnotations,
    onChange: e => setDeleteUserAnnotations(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    disabled: resetting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: resetJob,
    fill: true,
    disabled: resetting,
    color: "danger",
    "data-test-subj": "mlResetJobConfirmModalButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetButtonLabel",
    defaultMessage: "Reset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  })))));
};
exports.ResetJobModal = ResetJobModal;