"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewJobButton = NewJobButton;
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../../ml_nodes_check/check_ml_nodes");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _locator = require("../../../../../../common/constants/locator");
var _kibana = require("../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/new_job_button/new_job_button.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NewJobButton({
  size = 's'
}) {
  const canCreateJob = (0, _check_capabilities.usePermissionCheck)('canCreateJob');
  const buttonEnabled = canCreateJob && (0, _check_ml_nodes.mlNodesAvailable)();
  const mlLocator = (0, _kibana.useMlManagementLocator)();
  const redirectToCreateJobSelectIndexPage = (0, _react.useCallback)(async () => {
    if (!mlLocator || !canCreateJob) return;
    await mlLocator.navigate({
      sectionId: 'ml',
      appId: `anomaly_detection/${_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX}`
    });
  }, [mlLocator, canCreateJob]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlCreateNewJobButton",
    onClick: redirectToCreateJobSelectIndexPage,
    size: size,
    disabled: buttonEnabled === false,
    fill: true,
    iconType: "plusInCircle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.createNewJobButtonLabel",
    defaultMessage: "Create job",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
}