"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedFieldsMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _form_options_validation = require("./form_options_validation");
var _new_job_capabilities_service_analytics = require("../../../../../services/new_job_capabilities/new_job_capabilities_service_analytics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/supported_fields_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const containsClassificationFieldsCb = ({
  name,
  type
}) => !_mlAnomalyUtils.OMIT_FIELDS.includes(name) && name !== _mlAnomalyUtils.EVENT_RATE_FIELD_ID && (_mlDataFrameAnalyticsUtils.BASIC_NUMERICAL_TYPES.has(type) || _form_options_validation.CATEGORICAL_TYPES.has(type) || type === _fieldTypes.ES_FIELD_TYPES.BOOLEAN);
const containsRegressionFieldsCb = ({
  name,
  type
}) => !_mlAnomalyUtils.OMIT_FIELDS.includes(name) && name !== _mlAnomalyUtils.EVENT_RATE_FIELD_ID && (_mlDataFrameAnalyticsUtils.BASIC_NUMERICAL_TYPES.has(type) || _mlDataFrameAnalyticsUtils.EXTENDED_NUMERICAL_TYPES.has(type));
const containsOutlierFieldsCb = ({
  name,
  type
}) => !_mlAnomalyUtils.OMIT_FIELDS.includes(name) && name !== _mlAnomalyUtils.EVENT_RATE_FIELD_ID && (_mlDataFrameAnalyticsUtils.BASIC_NUMERICAL_TYPES.has(type) || _mlDataFrameAnalyticsUtils.EXTENDED_NUMERICAL_TYPES.has(type));
const callbacks = {
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: containsClassificationFieldsCb,
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION]: containsRegressionFieldsCb,
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: containsOutlierFieldsCb
};
const messages = {
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectClassificationHelpText",
    defaultMessage: "This data view does not contain any supported fields. Classification jobs require categorical, numeric, or boolean fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }),
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectRegressionHelpText",
    defaultMessage: "This data view does not contain any supported fields. Regression jobs require numeric fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }),
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.sourceObjectHelpText",
    defaultMessage: "This data view does not contain any numeric type fields. The analytics job may not be able to come up with any outliers.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  })
};
const SupportedFieldsMessage = ({
  jobType
}) => {
  const [sourceIndexContainsSupportedFields, setSourceIndexContainsSupportedFields] = (0, _react.useState)(true);
  const [sourceIndexFieldsCheckFailed, setSourceIndexFieldsCheckFailed] = (0, _react.useState)(false);
  const {
    fields
  } = (0, _new_job_capabilities_service_analytics.useNewJobCapsServiceAnalytics)();

  // Find out if data view contains supported fields for job type. Provides a hint in the form
  // that job may not run correctly if no supported fields are found.
  const validateFields = () => {
    if (fields && jobType !== undefined) {
      try {
        const containsSupportedFields = fields.some(callbacks[jobType]);
        setSourceIndexContainsSupportedFields(containsSupportedFields);
        setSourceIndexFieldsCheckFailed(false);
      } catch (e) {
        setSourceIndexFieldsCheckFailed(true);
      }
    }
  };
  (0, _react.useEffect)(() => {
    if (jobType !== undefined) {
      validateFields();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobType]);
  if (sourceIndexContainsSupportedFields === true) return null;
  if (sourceIndexFieldsCheckFailed === true) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.create.sourceIndexFieldsCheckError",
      defaultMessage: "There was a problem checking for supported fields for job type. Please refresh the page and try again.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, jobType !== undefined && messages[jobType]), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }));
};
exports.SupportedFieldsMessage = SupportedFieldsMessage;