"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPageControlsContext = exports.MlPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _react2 = require("@emotion/react");
var _locator = require("../../../../common/constants/locator");
var routes = _interopRequireWildcard(require("../../routing/routes"));
var overviewRoutes = _interopRequireWildcard(require("../../routing/routes/overview_management"));
var anomalyDetectionRoutes = _interopRequireWildcard(require("../../routing/routes/anomaly_detection_management"));
var dfaRoutes = _interopRequireWildcard(require("../../routing/routes/data_frame_analytics_management"));
var settingsRoutes = _interopRequireWildcard(require("../../routing/routes/settings"));
var trainedModelsRoutes = _interopRequireWildcard(require("../../routing/routes/trained_models"));
var _ml_page_wrapper = require("../../routing/ml_page_wrapper");
var _kibana = require("../../contexts/kibana");
var _use_active_route = require("../../routing/use_active_route");
var _use_doc_title = require("../../routing/use_doc_title");
var _page_header = require("../page_header/page_header");
var _side_nav = require("./side_nav");
var _ml = require("../../contexts/ml");
var _management = require("../../management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_page/ml_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ML_APP_SELECTOR = '[data-test-subj="mlApp"]';
const MlPageControlsContext = exports.MlPageControlsContext = /*#__PURE__*/(0, _react.createContext)({
  setHeaderActionMenu: () => {},
  headerPortal: (0, _reactReversePortal.createHtmlPortalNode)(),
  leftHeaderPortal: (0, _reactReversePortal.createHtmlPortalNode)(),
  rightHeaderPortal: (0, _reactReversePortal.createHtmlPortalNode)(),
  isHeaderMounted: false,
  setIsHeaderMounted: () => {},
  isLeftSectionMounted: false,
  setIsLeftSectionMounted: () => {},
  isRightSectionMounted: false,
  setIsRightSectionMounted: () => {},
  headerRestrictWidth: undefined,
  setHeaderRestrictWidth: () => {},
  wrapHeader: false,
  setWrapHeader: () => {}
});

/**
 * Main page component of the ML App
 * @constructor
 */
const MlPage = exports.MlPage = /*#__PURE__*/_react.default.memo(({
  pageDeps,
  entryPoint
}) => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const {
    pathname,
    search
  } = (0, _reactRouterDom.useLocation)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  (0, _react.useEffect)(
  // Auto-redirect bookmarked jobs list and data frame analytics list
  // to the new management pages, and keep the search string as much
  function autoRedirectToManagementPages() {
    if (mlManagementLocator) {
      const searchString = decodeURIComponent(search);
      let decodedSearch = search;
      const oldPath = pathname.slice(1);
      const newPath = _locator.DEPRECATED_ML_ROUTE_TO_NEW_ROUTE[oldPath];
      if (oldPath && newPath) {
        if (oldPath !== newPath) {
          decodedSearch = searchString.replace(`=(${oldPath}:`, `=('':`);
        }
        mlManagementLocator.navigate({
          sectionId: 'ml',
          appId: `${newPath}${decodedSearch}`
        });
        return;
      }
    }
  }, [pathname, navigateToPath, mlManagementLocator, search]);
  const {
    services: {
      application: {
        navigateToApp
      },
      http: {
        basePath
      },
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    showMLNavMenu
  } = (0, _ml.useEnabledFeatures)();
  const headerPortalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const leftHeaderPortalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const rightHeaderPortalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const [isHeaderMounted, setIsHeaderMounted] = (0, _react.useState)(false);
  const [isLeftSectionMounted, setIsLeftSectionMounted] = (0, _react.useState)(false);
  const [isRightSectionMounted, setIsRightSectionMounted] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [headerRestrictWidth, setHeaderRestrictWidth] = (0, _react.useState)(undefined);
  const [wrapHeader, setWrapHeader] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(httpService.getLoadingCount$.pipe((0, _rxjs.map)(v => v !== 0), (0, _rxjs.distinctUntilChanged)()).subscribe(loading => {
      setIsLoading(loading);
    }));
    return function cleanup() {
      subscriptions.unsubscribe();
    };
  }, [httpService === null || httpService === void 0 ? void 0 : httpService.getLoadingCount$]);
  const routeList = (0, _react.useMemo)(() => {
    let currentRoutes = routes;
    switch (entryPoint) {
      case _management.MANAGEMENT_SECTION_IDS.OVERVIEW:
        currentRoutes = overviewRoutes;
        break;
      case _management.MANAGEMENT_SECTION_IDS.ANOMALY_DETECTION:
        currentRoutes = anomalyDetectionRoutes;
        break;
      case _management.MANAGEMENT_SECTION_IDS.ANALYTICS:
        currentRoutes = dfaRoutes;
        break;
      case _management.MANAGEMENT_SECTION_IDS.TRAINED_MODELS:
        currentRoutes = trainedModelsRoutes;
        break;
      case _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS:
        currentRoutes = settingsRoutes;
        break;
      default:
        break;
    }
    const currentRoutesList = Object.values(currentRoutes);
    if (entryPoint !== undefined) {
      return currentRoutesList.map(routeFactory => routeFactory(navigateToApp)).filter(d => !d.disabled);
    } else {
      return currentRoutesList.map(routeFactory => routeFactory(navigateToPath, basePath.get())).filter(d => !d.disabled);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [entryPoint]);
  const activeRoute = (0, _use_active_route.useActiveRoute)(routeList);
  const headerChildren = (0, _react.useMemo)(() => {
    // This is a workaround for EUI issue, where passing restrictWidth along with children prop,
    // doesn't apply the max width - https://github.com/elastic/eui/pull/8965
    const styles = (0, _react2.css)`
        inline-size: 100%;
        max-inline-size: ${headerRestrictWidth}px;
        margin-inline: auto;
      `;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      css: styles,
      alignItems: "center",
      wrap: wrapHeader,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 13
      }
    }, isLeftSectionMounted ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: leftHeaderPortalNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 19
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeaderRenderer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    }, isRightSectionMounted ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: rightHeaderPortalNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 19
      }
    })) : null, activeRoute.enableDatePicker ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isLoading: isLoading,
      width: "full",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 19
      }
    })) : null)));
  }, [activeRoute.enableDatePicker, headerRestrictWidth, isLeftSectionMounted, isLoading, isRightSectionMounted, leftHeaderPortalNode, rightHeaderPortalNode, wrapHeader]);
  (0, _use_doc_title.useDocTitle)(activeRoute);

  // The deprecated `KibanaPageTemplate` from`'@kbn/kibana-react-plugin/public'`
  // had a `pageBodyProps` prop where we could pass in the `data-test-subj` for
  // the `main` element. This is no longer available in the update template
  // imported from `'@kbn/shared-ux-page-kibana-template'`. The following is a
  // workaround to add the `data-test-subj` on the `main` element again.
  (0, _react.useEffect)(() => {
    const mlApp = document.querySelector(ML_APP_SELECTOR);
    if (mlApp && typeof (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute['data-test-subj']) === 'string') {
      const mlAppMain = mlApp.querySelector('main');
      if (mlAppMain) {
        mlAppMain.setAttribute('data-test-subj', activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute['data-test-subj']);
      }
    }
  }, [activeRoute]);
  const sideNavItems = (0, _side_nav.useSideNavItems)(activeRoute);
  return /*#__PURE__*/_react.default.createElement(MlPageControlsContext.Provider, {
    value: {
      setHeaderActionMenu: pageDeps.setHeaderActionMenu,
      headerPortal: headerPortalNode,
      leftHeaderPortal: leftHeaderPortalNode,
      rightHeaderPortal: rightHeaderPortalNode,
      setIsHeaderMounted,
      isHeaderMounted,
      isLeftSectionMounted,
      setIsLeftSectionMounted,
      isRightSectionMounted,
      setIsRightSectionMounted,
      headerRestrictWidth,
      setHeaderRestrictWidth,
      wrapHeader,
      setWrapHeader
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, entryPoint === undefined ? /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    className: 'ml-app',
    "data-test-subj": 'mlApp',
    restrictWidth: false,
    panelled: true,
    solutionNav: showMLNavMenu ? {
      name: _i18n.i18n.translate('xpack.ml.plugin.title', {
        defaultMessage: 'Machine Learning'
      }),
      icon: 'machineLearningApp',
      items: sideNavItems
    } : undefined,
    pageHeader: {
      children: headerChildren,
      restrictWidth: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CommonPageWrapper, {
    headerPortal: headerPortalNode,
    setIsHeaderMounted: setIsHeaderMounted,
    pageDeps: pageDeps,
    routeList: routeList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    children: headerChildren,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(CommonPageWrapper, {
    headerPortal: headerPortalNode,
    setIsHeaderMounted: setIsHeaderMounted,
    pageDeps: pageDeps,
    routeList: routeList,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  })));
});
const CommonPageWrapper = /*#__PURE__*/_react.default.memo(({
  pageDeps,
  routeList,
  paddingSize
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useMlKibana)();
  return (
    /*#__PURE__*/
    /** RedirectAppLinks intercepts all <a> tags to use navigateToUrl
     * avoiding full page reload **/
    _react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      restrictWidth: false,
      paddingSize: paddingSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 11
      }
    }, routeList.map(route => {
      return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: route.path,
        path: route.path,
        exact: true,
        render: props => {
          window.setTimeout(() => {
            pageDeps.setBreadcrumbs(route.breadcrumbs);
          });
          return /*#__PURE__*/_react.default.createElement(_ml_page_wrapper.MlPageWrapper, {
            path: route.path,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 376,
              columnNumber: 23
            }
          }, route.render(props, pageDeps));
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 367,
          columnNumber: 17
        }
      });
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/overview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 13
      }
    }))))
  );
});