"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelectorTable = JobSelectorTable;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _custom_selection_table = require("../../custom_selection_table");
var _job_selector_badge = require("../job_selector_badge");
var _timerange_bar = require("../timerange_bar");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
var _app = require("../../../../../common/constants/app");
var _node_available_warning = require("../../node_available_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/job_selector_table/job_selector_table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JOB_FILTER_FIELDS = ['job_id', 'groups'];
const GROUP_FILTER_FIELDS = ['id'];
function JobSelectorTable({
  ganttBarWidth,
  groupsList,
  jobs,
  onSelection,
  selectedIds,
  singleSelection,
  timeseriesOnly,
  withTimeRangeSelector
}) {
  const [sortableProperties, setSortableProperties] = (0, _react.useState)();
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(true);
  const [currentTab, setCurrentTab] = (0, _react.useState)('Jobs');
  const {
    services: {
      application: {
        navigateToApp,
        capabilities: {
          ml: mlCapabilities
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  (0, _react.useEffect)(() => {
    let sortablePropertyItems = [];
    let defaultSortProperty = 'job_id';
    if (currentTab === 'Jobs' || singleSelection) {
      sortablePropertyItems = [{
        name: 'job_id',
        getValue: item => item.job_id.toLowerCase(),
        isAscending: true
      }, {
        name: 'groups',
        getValue: item => item.groups && item.groups[0] ? item.groups[0].toLowerCase() : '',
        isAscending: true
      }];
    } else if (currentTab === 'Groups') {
      defaultSortProperty = 'id';
      sortablePropertyItems = [{
        name: 'id',
        getValue: item => item.id.toLowerCase(),
        isAscending: true
      }];
    }
    const sortableProps = new _eui.SortableProperties(sortablePropertyItems, defaultSortProperty);
    setSortableProperties(sortableProps);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobs, currentTab]);
  const tabs = [{
    id: 'Jobs',
    name: _i18n.i18n.translate('xpack.ml.jobSelector.jobsTab', {
      defaultMessage: 'Jobs'
    }),
    content: renderJobsTable()
  }, {
    id: 'Groups',
    name: _i18n.i18n.translate('xpack.ml.jobSelector.groupsTab', {
      defaultMessage: 'Groups'
    }),
    content: renderGroupsTable()
  }];
  function getGroupOptions() {
    return groupsList.map(g => ({
      value: g.id,
      view: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: g.id,
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
        id: g.id,
        isGroup: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.ml.jobSelector.filterBar.jobGroupTitle', {
        defaultMessage: `({jobsCount, plural, one {# job} other {# jobs}})`,
        values: {
          jobsCount: g.jobIds.length
        }
      }))))
    }));
  }
  function renderJobsTable() {
    const columns = [{
      id: 'checkbox',
      isCheckbox: true,
      textOnly: false,
      width: '32px'
    }, {
      label: 'job ID',
      id: 'job_id',
      isSortable: true,
      alignment: _eui.LEFT_ALIGNMENT
    }, {
      id: 'groups',
      label: 'groups',
      isSortable: true,
      alignment: _eui.LEFT_ALIGNMENT,
      render: ({
        groups = []
      }) => groups.map(group => /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
        key: `${group}-key`,
        id: group,
        isGroup: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }))
    }];
    if (withTimeRangeSelector) {
      columns.push({
        label: 'time range',
        id: 'timerange',
        alignment: _eui.LEFT_ALIGNMENT,
        render: ({
          timeRange = {},
          isRunning
        }) => /*#__PURE__*/_react.default.createElement(_timerange_bar.TimeRangeBar, {
          timerange: timeRange,
          isRunning: isRunning,
          ganttBarWidth: ganttBarWidth,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 161,
            columnNumber: 11
          }
        })
      });
    }
    const filters = [{
      type: 'field_value_selection',
      field: 'groups',
      name: _i18n.i18n.translate('xpack.ml.jobSelector.filterBar.groupLabel', {
        defaultMessage: 'Group'
      }),
      loadingMessage: 'Loading...',
      noOptionsMessage: 'No groups found.',
      multiSelect: 'or',
      cache: 10000,
      options: getGroupOptions()
    }];
    return /*#__PURE__*/_react.default.createElement(_custom_selection_table.CustomSelectionTable, {
      columns: columns,
      filters: filters,
      filterDefaultFields: !singleSelection ? JOB_FILTER_FIELDS : undefined,
      items: jobs,
      onTableChange: selectionFromTable => onSelection({
        selectionFromTable
      }),
      radioDisabledCheck: item => {
        return timeseriesOnly && item.isSingleMetricViewerJob === false;
      },
      selectedIds: selectedIds,
      singleSelection: singleSelection,
      sortableProperties: sortableProperties,
      timeseriesOnly: timeseriesOnly,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 7
      }
    });
  }
  function renderGroupsTable() {
    const groupColumns = [{
      id: 'checkbox',
      isCheckbox: true,
      textOnly: false,
      width: '32px'
    }, {
      label: 'group ID',
      id: 'id',
      isSortable: true,
      alignment: _eui.LEFT_ALIGNMENT,
      render: ({
        id
      }) => /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
        id: id,
        isGroup: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 29
        }
      })
    }, {
      id: 'jobs in group',
      label: 'jobs in group',
      isSortable: false,
      alignment: _eui.CENTER_ALIGNMENT,
      render: ({
        jobIds = []
      }) => jobIds.length
    }];
    if (withTimeRangeSelector) {
      groupColumns.push({
        label: 'time range',
        id: 'timerange',
        alignment: _eui.LEFT_ALIGNMENT,
        render: ({
          timeRange = {}
        }) => /*#__PURE__*/_react.default.createElement(_timerange_bar.TimeRangeBar, {
          timerange: timeRange,
          ganttBarWidth: ganttBarWidth,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 11
          }
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement(_custom_selection_table.CustomSelectionTable, {
      columns: groupColumns,
      filterDefaultFields: !singleSelection ? GROUP_FILTER_FIELDS : undefined,
      items: groupsList,
      onTableChange: selectionFromTable => onSelection({
        selectionFromTable
      }),
      selectedIds: selectedIds,
      sortableProperties: sortableProperties,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 7
      }
    });
  }
  function renderTabs() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
      size: "s",
      tabs: tabs,
      initialSelectedTab: tabs[0],
      onTabClick: tab => {
        setCurrentTab(tab.id);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 7
      }
    });
  }
  const navigateToWizard = async () => {
    await navigateToApp(_app.PLUGIN_ID, {
      path: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_node_available_warning.MlNodeAvailableWarningShared, {
    nodeAvailableCallback: setMlNodesAvailable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }), jobs.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.noJobsFoundTitle",
      defaultMessage: "No anomaly detection jobs found",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 15
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      color: "primary",
      onClick: navigateToWizard,
      disabled: mlCapabilities.canCreateJob === false || mlNodesAvailable === false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.createJobButtonLabel",
      defaultMessage: "Create job",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 15
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }), jobs.length !== 0 && singleSelection === true && renderJobsTable(), jobs.length !== 0 && !singleSelection && renderTabs());
}
JobSelectorTable.propTypes = {
  ganttBarWidth: _propTypes.PropTypes.number.isRequired,
  groupsList: _propTypes.PropTypes.array,
  jobs: _propTypes.PropTypes.array,
  onSelection: _propTypes.PropTypes.func.isRequired,
  selectedIds: _propTypes.PropTypes.array.isRequired,
  singleSelection: _propTypes.PropTypes.bool,
  timeseriesOnly: _propTypes.PropTypes.bool,
  withTimeRangeSelector: _propTypes.PropTypes.bool
};