"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrdinalDataMappingPopover = OrdinalDataMappingPopover;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _vector_style_defaults = require("../../vector_style_defaults");
var _data_mapping_popover = require("./data_mapping_popover");
var _constants = require("../../../../../../common/constants");
var _percentiles_form = require("./percentiles_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/data_mapping/ordinal_data_mapping_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const interpolateTitle = _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.interpolateTitle', {
  defaultMessage: `Interpolate between min and max`
});
const percentilesTitle = _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.percentilesTitle', {
  defaultMessage: `Use percentiles`
});
const DATA_MAPPING_OPTIONS = [{
  value: _constants.DATA_MAPPING_FUNCTION.INTERPOLATE,
  inputDisplay: interpolateTitle,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, interpolateTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.styles.ordinalDataMapping.interpolateDescription",
    defaultMessage: "Interpolate values from the data domain to the style on a linear scale",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }))))
}, {
  value: _constants.DATA_MAPPING_FUNCTION.PERCENTILES,
  inputDisplay: percentilesTitle,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, percentilesTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.styles.ordinalDataMapping.percentilesDescription",
    defaultMessage: "Divide style into bands that map to values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }))))
}];
function OrdinalDataMappingPopover(props) {
  function onIsEnabledChange(event) {
    // @ts-expect-error
    props.onChange({
      fieldMetaOptions: {
        ...props.fieldMetaOptions,
        isEnabled: event.target.checked
      }
    });
  }
  function onSigmaChange(event) {
    // @ts-expect-error
    props.onChange({
      fieldMetaOptions: {
        ...props.fieldMetaOptions,
        sigma: parseInt(event.currentTarget.value, 10)
      }
    });
  }
  function onDataMappingFunctionChange(value) {
    const updatedOptions = value === _constants.DATA_MAPPING_FUNCTION.PERCENTILES ? {
      dataMappingFunction: value,
      fieldMetaOptions: {
        ...props.fieldMetaOptions,
        isEnabled: true,
        percentiles: props.fieldMetaOptions.percentiles ? props.fieldMetaOptions.percentiles : _constants.DEFAULT_PERCENTILES
      }
    } : {
      dataMappingFunction: value
    };
    // @ts-expect-error
    props.onChange(updatedOptions);
  }
  function renderEasingForm() {
    const sigmaInput = props.fieldMetaOptions.isEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.sigmaLabel', {
        defaultMessage: 'Sigma'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        anchorClassName: "eui-alignMiddle",
        content: _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.sigmaTooltipContent', {
          defaultMessage: `To de-emphasize outliers, set sigma to a smaller value. Smaller sigmas move the min and max closer to the median.`
        }),
        type: "question",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 13
        }
      })),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
      min: 1,
      max: 5,
      step: 0.25,
      value: _lodash.default.get(props.fieldMetaOptions, 'sigma', _vector_style_defaults.DEFAULT_SIGMA),
      onChange: onSigmaChange,
      showTicks: true,
      tickInterval: 1,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.isEnabledSwitchLabel', {
        defaultMessage: 'Get min and max from data set'
      }),
      checked: props.fieldMetaOptions.isEnabled,
      onChange: onIsEnabledChange,
      disabled: !props.supportsFieldMetaFromLocalData,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.styles.ordinalDataMapping.isEnabled.server",
        defaultMessage: "Calculate min and max from the entire data set. Styling is consistent when users pan, zoom, and filter. To minimize outliers, min and max are clamped to the standard deviation (sigma) from the medium.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.styles.ordinalDataMapping.isEnabled.local",
        defaultMessage: "When disabled, calculate min and max from local data and recalculate min and max when the data changes. Styling may be inconsistent when users pan, zoom, and filter.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 21
        }
      }))),
      type: "question",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }))), sigmaInput);
  }
  function renderPercentilesForm() {
    function onPercentilesChange(percentiles) {
      // @ts-expect-error
      props.onChange({
        fieldMetaOptions: {
          ...props.fieldMetaOptions,
          percentiles: _lodash.default.uniq(percentiles.sort())
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_percentiles_form.PercentilesForm, {
      initialPercentiles: props.fieldMetaOptions.percentiles ? props.fieldMetaOptions.percentiles : _constants.DEFAULT_PERCENTILES,
      onChange: onPercentilesChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 7
      }
    });
  }
  const dataMappingOptions = DATA_MAPPING_OPTIONS.filter(option => {
    return props.supportedDataMappingFunctions.includes(option.value);
  });
  return /*#__PURE__*/_react.default.createElement(_data_mapping_popover.DataMappingPopover, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.dataMappingLabel', {
      defaultMessage: 'Fitting'
    }),
    helpText: _i18n.i18n.translate('xpack.maps.styles.ordinalDataMapping.dataMappingTooltipContent', {
      defaultMessage: `Fit values from the data domain to the style`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: dataMappingOptions,
    valueOfSelected: props.dataMappingFunction,
    onChange: onDataMappingFunctionChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }), props.dataMappingFunction === _constants.DATA_MAPPING_FUNCTION.PERCENTILES ? renderPercentilesForm() : renderEasingForm()));
}