"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogSourcesService = createLogSourcesService;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _utils = require("../../../common/services/log_sources_service/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createLogSourcesService(params) {
  const {
    uiSettings
  } = params.deps;
  const getLogSources = async () => {
    const logSources = uiSettings.get(_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID);
    return logSources.map(logSource => ({
      indexPattern: logSource
    }));
  };
  const getFlattenedLogSources = async () => {
    const logSources = await getLogSources();
    return (0, _utils.flattenLogSources)(logSources);
  };
  const setLogSources = async sources => {
    await uiSettings.set(_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID, sources.map(source => source.indexPattern));
    return;
  };
  const logSourcesService = {
    getLogSources,
    getFlattenedLogSources,
    setLogSources
  };
  return logSourcesService;
}