"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ExceptionBuilderComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _and_or_badge = require("../and_or_badge");
var _exception_item_renderer = require("./exception_item_renderer");
var _logic_buttons = require("./logic_buttons");
var _selectors = require("./selectors");
var _reducer = require("./reducer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/lists/public/exceptions/components/builder/exception_items_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyInvisibleAndBadge = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  visibility: hidden;
`;
const MyAndBadge = (0, _styledComponents.default)(_and_or_badge.AndOrBadge)`
  & > .euiFlexItem {
    margin: 0;
  }
`;
const MyButtonsContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin: 8px 0;
`;
const initialState = {
  addNested: false,
  andLogicIncluded: false,
  disableAnd: false,
  disableNested: false,
  disableOr: false,
  errors: {},
  exceptions: [],
  exceptionsToDelete: [],
  warningExists: 0
};
const ExceptionBuilderComponent = ({
  allowLargeValueLists,
  autocompleteService,
  exceptionListItems,
  httpService,
  indexPatterns,
  isAndDisabled,
  isNestedDisabled,
  isOrDisabled,
  isOrHidden = false,
  listId,
  listNamespaceType,
  listType,
  onChange,
  ruleName,
  exceptionItemName,
  isDisabled = false,
  osTypes,
  operatorsList,
  allowCustomFieldOptions = false,
  getExtendedFields,
  showValueListModal
}) => {
  const [state, dispatch] = (0, _react.useReducer)((0, _reducer.exceptionsBuilderReducer)(), {
    ...initialState,
    disableAnd: isAndDisabled,
    disableNested: isNestedDisabled,
    disableOr: isOrDisabled
  });
  const [areAllEntriesDeleted, setAreAllEntriesDeleted] = (0, _react.useState)(false);
  const {
    addNested,
    andLogicIncluded,
    disableAnd,
    disableNested,
    disableOr,
    warningExists,
    exceptions,
    exceptionsToDelete
  } = state;
  const errorExists = (0, _selectors.getTotalErrorExist)(state);
  const setErrorsExist = (0, _react.useCallback)(error => {
    dispatch({
      error,
      type: 'setErrorsExist'
    });
  }, [dispatch]);
  const setWarningsExist = (0, _react.useCallback)(hasWarnings => {
    dispatch({
      type: 'setWarningsExist',
      warningExists: hasWarnings
    });
  }, [dispatch]);
  const setUpdateExceptions = (0, _react.useCallback)(items => {
    dispatch({
      exceptions: items,
      type: 'setExceptions'
    });
  }, [dispatch]);
  const setDefaultExceptions = (0, _react.useCallback)(item => {
    dispatch({
      initialState,
      lastException: item,
      type: 'setDefault'
    });
  }, [dispatch]);
  const setUpdateExceptionsToDelete = (0, _react.useCallback)(items => {
    dispatch({
      exceptions: items,
      type: 'setExceptionsToDelete'
    });
  }, [dispatch]);
  const setUpdateAndDisabled = (0, _react.useCallback)(shouldDisable => {
    dispatch({
      shouldDisable,
      type: 'setDisableAnd'
    });
  }, [dispatch]);
  const setUpdateOrDisabled = (0, _react.useCallback)(shouldDisable => {
    dispatch({
      shouldDisable,
      type: 'setDisableOr'
    });
  }, [dispatch]);
  const setUpdateAddNested = (0, _react.useCallback)(shouldAddNested => {
    dispatch({
      addNested: shouldAddNested,
      type: 'setAddNested'
    });
  }, [dispatch]);
  const handleExceptionItemChange = (0, _react.useCallback)((item, index) => {
    const updatedExceptions = [...exceptions.slice(0, index), {
      ...item
    }, ...exceptions.slice(index + 1)];
    setUpdateExceptions(updatedExceptions);
  }, [setUpdateExceptions, exceptions]);
  const handleDeleteExceptionItem = (0, _react.useCallback)((item, itemIndex) => {
    if (item.entries.length === 0) {
      const updatedExceptions = [...exceptions.slice(0, itemIndex), ...exceptions.slice(itemIndex + 1)];

      // if it's the only exception item left, don't delete it
      // just add a default entry to it
      if (updatedExceptions.length === 0) {
        setDefaultExceptions(item);
        setAreAllEntriesDeleted(true);
      } else if (updatedExceptions.length > 0 && _securitysolutionIoTsListTypes.exceptionListItemSchema.is(item)) {
        setUpdateExceptionsToDelete([...exceptionsToDelete, item]);
      } else {
        setUpdateExceptions([...exceptions.slice(0, itemIndex), ...exceptions.slice(itemIndex + 1)]);
      }
    } else {
      handleExceptionItemChange(item, itemIndex);
    }
  }, [handleExceptionItemChange, setUpdateExceptions, setUpdateExceptionsToDelete, exceptions, exceptionsToDelete, setDefaultExceptions]);
  const handleAddNewExceptionItemEntry = (0, _react.useCallback)((isNested = false) => {
    const lastException = exceptions[exceptions.length - 1];
    const {
      entries
    } = lastException;
    const updatedException = {
      ...lastException,
      entries: [...entries, isNested ? (0, _securitysolutionListUtils.getDefaultNestedEmptyEntry)() : (0, _securitysolutionListUtils.getDefaultEmptyEntry)()]
    };
    setUpdateExceptions([...exceptions.slice(0, exceptions.length - 1), {
      ...updatedException
    }]);
  }, [setUpdateExceptions, exceptions]);
  const handleAddNewExceptionItem = (0, _react.useCallback)(() => {
    // There is a case where there are numerous exception list items, all with
    // empty `entries` array. Thought about appending an entry item to one, but that
    // would then be arbitrary, decided to just create a new exception list item
    const newException = (0, _securitysolutionListUtils.getNewExceptionItem)({
      listId,
      name: exceptionItemName !== null && exceptionItemName !== void 0 ? exceptionItemName : `${ruleName !== null && ruleName !== void 0 ? ruleName : 'Rule'} - Exception item`,
      namespaceType: listNamespaceType
    });
    setUpdateExceptions([...exceptions, {
      ...newException
    }]);
  }, [setUpdateExceptions, exceptions, listId, listNamespaceType, ruleName, exceptionItemName]);

  // The builder can have existing exception items, or new exception items that have yet
  // to be created (and thus lack an id), this was creating some React bugs with relying
  // on the index, as a result, created a temporary id when new exception items are first
  // instantiated that is stored in `meta` that gets stripped on it's way out
  const getExceptionListItemId = (item, index) => {
    if (item.id != null) {
      return item.id;
    } else if (item.meta.temporaryUuid != null) {
      return item.meta.temporaryUuid;
    } else {
      return `${index}`;
    }
  };
  const handleAddNestedExceptionItemEntry = (0, _react.useCallback)(() => {
    const lastException = exceptions[exceptions.length - 1];
    const {
      entries
    } = lastException;
    const lastEntry = entries[entries.length - 1];
    if (_securitysolutionIoTsListTypes.entriesNested.is(lastEntry)) {
      const updatedException = {
        ...lastException,
        entries: [...entries.slice(0, entries.length - 1), {
          ...lastEntry,
          entries: [...lastEntry.entries, (0, _securitysolutionUtils.addIdToItem)({
            field: '',
            operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
            type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH,
            value: ''
          })]
        }]
      };
      setUpdateExceptions([...exceptions.slice(0, exceptions.length - 1), {
        ...updatedException
      }]);
    } else {
      setUpdateExceptions(exceptions);
    }
  }, [setUpdateExceptions, exceptions]);
  const handleAddNestedClick = (0, _react.useCallback)(() => {
    setUpdateAddNested(true);
    setUpdateOrDisabled(true);
    setUpdateAndDisabled(true);
    handleAddNewExceptionItemEntry(true);
  }, [handleAddNewExceptionItemEntry, setUpdateAndDisabled, setUpdateOrDisabled, setUpdateAddNested]);
  const handleAddClick = (0, _react.useCallback)(() => {
    setUpdateAddNested(false);
    setUpdateOrDisabled(false);
    handleAddNewExceptionItemEntry();
  }, [handleAddNewExceptionItemEntry, setUpdateOrDisabled, setUpdateAddNested]);
  const memoExceptionItems = (0, _react.useMemo)(() => {
    return (0, _securitysolutionListUtils.filterExceptionItems)(exceptions);
  }, [exceptions]);

  // useEffect(() => {
  //   setUpdateExceptions([]);
  // }, [osTypes, setUpdateExceptions]);

  // Bubble up changes to parent
  (0, _react.useEffect)(() => {
    onChange({
      errorExists: errorExists > 0,
      exceptionItems: memoExceptionItems,
      exceptionsToDelete,
      warningExists: warningExists > 0
    });
  }, [onChange, exceptionsToDelete, memoExceptionItems, errorExists, warningExists]);

  // Defaults builder to never be sans entry, instead
  // always falls back to an empty entry if user deletes all
  (0, _react.useEffect)(() => {
    if (exceptions.length === 0 || exceptions.length === 1 && exceptions[0].entries != null && exceptions[0].entries.length === 0) {
      handleAddNewExceptionItem();
    }
  }, [exceptions, handleAddNewExceptionItem]);

  /**
   * This component relies on the "exceptionListItems" to pre-fill its entries,
   *  but any subsequent updates to the entries are not reflected back to
   * the "exceptionListItems". To ensure correct behavior, we need to only
   * fill the entries from the "exceptionListItems" during initialization.
   *
   * In the initialization phase, if there are "exceptionListItems" with
   * pre-filled entries, the exceptions array will be empty. However,
   * there are cases where the "exceptionListItems" may not be sent
   * correctly during initialization, leading to the exceptions
   * array being filled with empty entries. Therefore, we need to
   *  check if the exception is correctly populated with a valid
   * "field" when the "exceptionListItems" has entries. that's why
   * "exceptionsEntriesPopulated" is used
   *
   * It's important to differentiate this case from when the user
   * deletes all the entries and the "exceptionListItems" has pre-filled values.
   * that's why "allEntriesDeleted" is used
   *
   *  deepEqual(exceptionListItems, exceptions) to handle the exceptionListItems in
   * the EventFiltersFlyout
   */
  (0, _react.useEffect)(() => {
    if (!exceptionListItems.length || (0, _fastDeepEqual.default)(exceptionListItems, exceptions)) return;
    const exceptionsEntriesPopulated = exceptions.some(exception => exception.entries.some(entry => entry.field));
    if (!exceptionsEntriesPopulated && !areAllEntriesDeleted) setUpdateExceptions(exceptionListItems);
  }, [areAllEntriesDeleted, exceptionListItems, exceptions, setUpdateExceptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": "exceptionsBuilderWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 5
    }
  }, exceptions.map((exceptionListItem, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    key: getExceptionListItemId(exceptionListItem, index),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 11
    }
  }, index !== 0 && (andLogicIncluded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
    includeAntennas: true,
    type: "and",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
    type: "or",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 23
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
    type: "or",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_exception_item_renderer.BuilderExceptionListItemComponent, {
    allowLargeValueLists: allowLargeValueLists,
    andLogicIncluded: andLogicIncluded,
    autocompleteService: autocompleteService,
    exceptionItem: exceptionListItem,
    exceptionItemIndex: index,
    httpService: httpService,
    indexPattern: indexPatterns,
    isOnlyItem: exceptions.length === 1,
    key: getExceptionListItemId(exceptionListItem, index),
    listType: listType,
    onChangeExceptionItem: handleExceptionItemChange,
    onDeleteExceptionItem: handleDeleteExceptionItem,
    onlyShowListOperators: (0, _securitysolutionListUtils.containsValueListEntry)(exceptions),
    setErrorsExist: setErrorsExist,
    setWarningsExist: setWarningsExist,
    osTypes: osTypes,
    isDisabled: isDisabled,
    operatorsList: operatorsList,
    allowCustomOptions: allowCustomFieldOptions,
    getExtendedFields: getExtendedFields,
    showValueListModal: showValueListModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(MyButtonsContainer, {
    "data-test-subj": `andOrOperatorButtons`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 9
    }
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    includeAntennas: true,
    type: "and",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_logic_buttons.BuilderLogicButtons, {
    isOrDisabled: isOrDisabled ? isOrDisabled : disableOr,
    isOrHidden: isOrHidden,
    isAndDisabled: isAndDisabled ? isAndDisabled : disableAnd,
    isNestedDisabled: isNestedDisabled ? isNestedDisabled : disableNested,
    isNested: addNested,
    showNestedButton: true,
    onOrClicked: handleAddNewExceptionItem,
    onAndClicked: handleAddClick,
    onNestedClicked: handleAddNestedClick,
    onAddClickWhenNested: handleAddNestedExceptionItemEntry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 13
    }
  })))));
};
exports.ExceptionBuilderComponent = ExceptionBuilderComponent;
ExceptionBuilderComponent.displayName = 'ExceptionBuilder';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ExceptionBuilderComponent;