"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkDestination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _external_link_destination_picker = require("../external_link/external_link_destination_picker");
var _dashboard_link_destination_picker = require("../dashboard_link/dashboard_link_destination_picker");
var _links_strings = require("../links_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/editor/link_destination.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkDestination = ({
  link,
  setDestination,
  parentDashboardId,
  selectedLinkType
}) => {
  const [destinationError, setDestinationError] = (0, _react.useState)();

  /**
   * Store the dashboard / external destinations separately so that we can remember the selections
   * made in each component even when the selected link type changes
   */
  const [dashboardLinkDestination, setDashboardLinkDestination] = (0, _react.useState)(link && link.type === _content_management.DASHBOARD_LINK_TYPE ? link.destination : undefined);
  const [externalLinkDestination, setExternalLinkDestination] = (0, _react.useState)(link && link.type === _content_management.EXTERNAL_LINK_TYPE ? link.destination : undefined);
  const isInvalid = Boolean(destinationError);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: destinationError,
    isInvalid: isInvalid,
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkDestinationLabel(),
    "data-test-subj": `links--linkDestination${isInvalid ? '--error' : ''}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, selectedLinkType === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_destination_picker.DashboardLinkDestinationPicker, {
    onUnmount: selectedDashboardId => {
      setDestination(undefined, undefined);
      if (selectedDashboardId) setDashboardLinkDestination(selectedDashboardId);
    },
    parentDashboardId: parentDashboardId,
    initialSelection: dashboardLinkDestination,
    onDestinationPicked: dashboard => setDestination(dashboard === null || dashboard === void 0 ? void 0 : dashboard.id, dashboard === null || dashboard === void 0 ? void 0 : dashboard.title, dashboard === null || dashboard === void 0 ? void 0 : dashboard.description),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_external_link_destination_picker.ExternalLinkDestinationPicker, {
    onUnmount: selectedUrl => {
      setDestinationError(undefined);
      setDestination(undefined, undefined);
      if (selectedUrl) setExternalLinkDestination(selectedUrl);
    },
    initialSelection: externalLinkDestination,
    onDestinationPicked: url => setDestination(url, url),
    setDestinationError: setDestinationError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }));
};
exports.LinkDestination = LinkDestination;