"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensResponseItemSchema = exports.lensItemMetaSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _content_management = require("../../../../content_management");
var _utils = require("../../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The Lens item meta returned from the server
 */
const lensItemMetaSchema = exports.lensItemMetaSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(_content_management.lensSavedObjectSchema.getPropSchemas(), ['type', 'createdAt', 'updatedAt', 'createdBy', 'updatedBy', 'originId', 'managed'])
}, {
  unknowns: 'forbid'
});

/**
 * The Lens response item returned from the server
 */
const lensResponseItemSchema = exports.lensResponseItemSchema = _configSchema.schema.object({
  id: _content_management.lensSavedObjectSchema.getPropSchemas().id,
  data: _configSchema.schema.oneOf([_lensEmbeddableUtils.lensApiStateSchema, _content_management.lensItemDataSchema]),
  meta: lensItemMetaSchema
}, {
  unknowns: 'forbid'
});