"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapHorizontalAxisSettings = HeatmapHorizontalAxisSettings;
exports.HeatmapStyleSettings = HeatmapStyleSettings;
exports.HeatmapTitlesAndTextSettings = HeatmapTitlesAndTextSettings;
exports.HeatmapVerticalAxisSettings = HeatmapVerticalAxisSettings;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/heatmap/toolbar_component/style_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HeatmapStyleSettings(props) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.titlesAndText', {
      defaultMessage: 'Titles and text'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(HeatmapTitlesAndTextSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.verticalAxis', {
      defaultMessage: 'Vertical axis'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(HeatmapVerticalAxisSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.horizontalAxis', {
      defaultMessage: 'Horizontal axis'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(HeatmapHorizontalAxisSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }))));
}
function HeatmapTitlesAndTextSettings({
  state,
  setState
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_components.ValueLabelsSettings, {
    valueLabels: state !== null && state !== void 0 && state.gridConfig.isCellLabelVisible ? 'show' : 'hide',
    onValueLabelChange: newMode => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isCellLabelVisible: newMode === 'show'
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
}
function HeatmapVerticalAxisSettings({
  state,
  setState
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: "yLeft",
    title: state === null || state === void 0 ? void 0 : state.gridConfig.yTitle,
    updateTitleState: ({
      title,
      visible
    }) => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          yTitle: title,
          isYAxisTitleVisible: visible
        }
      });
    },
    isTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisTitleVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "yLeft",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isYAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisLabelVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
}
function HeatmapHorizontalAxisSettings({
  state,
  setState
}) {
  const isXAxisLabelVisible = state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisLabelVisible;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: "x",
    title: state === null || state === void 0 ? void 0 : state.gridConfig.xTitle,
    updateTitleState: ({
      title,
      visible
    }) => setState({
      ...state,
      gridConfig: {
        ...state.gridConfig,
        xTitle: title,
        isXAxisTitleVisible: visible
      }
    }),
    isTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisTitleVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "x",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isXAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: isXAxisLabelVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), isXAxisLabelVisible && /*#__PURE__*/_react.default.createElement(_shared_components.AxisLabelOrientationSelector, {
    axis: "x",
    selectedLabelOrientation: _shared_components.allowedOrientations.includes(state.gridConfig.xAxisLabelRotation) ? state.gridConfig.xAxisLabelRotation : 0 // Default to 0 if the value is not valid
    ,
    setLabelOrientation: orientation => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          xAxisLabelRotation: orientation
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }));
}