"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutContainer = FlyoutContainer;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _flyout = require("./flyout.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/flyout_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function fromExcludedClickTarget(event) {
  for (let node = event.target; node !== null; node = node.parentElement) {
    if (node.classList.contains(_utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS) || node.classList.contains('euiBody-hasPortalContent') || node.getAttribute('data-euiportal') === 'true') {
      return true;
    }
  }
  return false;
}
function FlyoutContainer({
  isOpen,
  label,
  handleClose,
  isFullscreen,
  panelRef,
  panelContainerRef,
  children,
  customFooter,
  isInlineEditing,
  overrideContainerCss
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const closeFlyout = (0, _react.useCallback)(() => {
    setFocusTrapIsEnabled(false);
    handleClose();
  }, [handleClose]);
  (0, _react.useEffect)(() => {
    if (!isInlineEditing) {
      if (isOpen) {
        document.body.style.overflow = isOpen ? 'hidden' : '';
      }
      return () => {
        if (isOpen) {
          setFocusTrapIsEnabled(false);
        }
        document.body.style.overflow = '';
      };
    }
  }, [isInlineEditing, isOpen]);
  if (!isOpen) {
    return null;
  }
  const hideShadow = isInlineEditing || isFullscreen;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: false,
    onClickOutside: event => {
      if (isFullscreen || fromExcludedClickTarget(event)) {
        return;
      }
      closeFlyout();
    },
    onEscapeKey: closeFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: panelContainerRef,
    role: "dialog",
    "aria-labelledby": "lnsDimensionContainerTitle",
    css: [(0, _react2.css)`
              box-shadow: ${hideShadow ? 'none !important' : 'inherit'};
            `, (0, _flyout.flyoutContainerStyles)(euiThemeContext), dimensionContainerStyles.self(euiThemeContext), overrideContainerCss],
    onAnimationEnd: () => {
      if (isOpen) {
        // EuiFocusTrap interferes with animating elements with absolute position:
        // running this onAnimationEnd, otherwise the flyout pushes content when animating.
        setFocusTrapIsEnabled(true);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: dimensionContainerStyles.header(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, isInlineEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-dimensionContainerBack",
    className: "lnsDimensionContainer__backIcon",
    onClick: closeFlyout,
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('xpack.lens.dimensionContainer.closeConfiguration', {
      defaultMessage: 'Close configuration'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "lnsDimensionContainerTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 19
    }
  }, label))), !isInlineEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-dimensionContainerBack",
    className: "lnsDimensionContainer__backIcon",
    onClick: closeFlyout,
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('xpack.lens.dimensionContainer.closeConfiguration', {
      defaultMessage: 'Close configuration'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: (0, _react2.css)`
              flex: 1;
              z-index: 1;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, children), customFooter || /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    css: dimensionContainerStyles.footer(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: isInlineEditing ? 'sortLeft' : 'cross',
    onClick: closeFlyout,
    "data-test-subj": "lns-indexPattern-dimensionContainerClose",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }, isInlineEditing ? _i18n.i18n.translate('xpack.lens.dimensionContainer.back', {
    defaultMessage: 'Back'
  }) : _i18n.i18n.translate('xpack.lens.dimensionContainer.close', {
    defaultMessage: 'Close'
  }))))));
}
const dimensionContainerStyles = {
  self: euiThemeContext => {
    return (0, _react2.css)`
      // But with custom positioning to keep it within the sidebar contents
      max-width: none !important;
      left: 0;
      ${(0, _eui.euiBreakpoint)(euiThemeContext, ['m', 'l', 'xl'])} {
        height: 100% !important;
        position: absolute;
        top: 0 !important;
      }
    `;
  },
  header: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.base};
  `,
  footer: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.base};
  `
};