"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameLayout = FrameLayout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _state_management = require("../../state_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/frame_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FrameLayout(props) {
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    alignItems: "stretch",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, props.bannerMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("aside", {
    "aria-labelledby": "bannerMessagesId",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "bannerMessagesId",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.lens.section.bannerMessagesLabel', {
    defaultMessage: 'Deprecation messages'
  }))), props.bannerMessages)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: (0, _react2.css)`
          position: relative;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "none",
    css: (0, _react2.css)`
            padding: 0;
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            overflow: hidden;
            flex-direction: column;
            ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
              position: static;
            }
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: false,
    className: "lnsFrameLayout__pageContent",
    "aria-labelledby": "lns_ChartTitle",
    css: (0, _react2.css)`
              overflow: hidden;
              flex-grow: 1;
              flex-direction: row;
              ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
                flex-wrap: wrap;
                overflow: auto;
                > * {
                  flex-basis: 100%;
                }
              }
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "hide-for-sharing",
    "aria-labelledby": "dataPanelId",
    css: [sidebarStyles(euiThemeContext), isFullscreen && (0, _react2.css)`
                    // Hide the datapanel in fullscreen mode. Using display: none does trigger
                    // a rerender when the container becomes visible again, maybe pushing offscreen is better
                    display: none;
                  `],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "dataPanelId",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.lens.section.dataPanelLabel', {
    defaultMessage: 'Data panel'
  }))), props.dataPanel), /*#__PURE__*/_react.default.createElement("section", {
    className: (0, _classnames.default)('eui-scrollBar', 'lnsVisualizationWorkspace_container'),
    css: (0, _react2.css)`
                min-width: 432px;
                overflow: hidden auto;
                display: flex;
                flex-direction: column;
                flex: 1 1 100%;
                // Leave out bottom padding so the suggestions scrollbar stays flush to window edge
                // Leave out left padding so the left sidebar's focus states are visible outside of content bounds
                // This also means needing to add same amount of margin to page content and suggestion items
                padding: ${euiTheme.size.base} ${euiTheme.size.base} 0;
                position: relative;
                z-index: 1;
                border-left: ${euiTheme.border.thin};
                border-right: ${euiTheme.border.thin};
                &:first-child {
                  padding-left: ${euiTheme.size.base};
                }
                ${isFullscreen && `
                  flex: 1;
                  padding: 0;`}
              `,
    "aria-labelledby": "workspaceId",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "workspaceId",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.lens.section.workspaceLabel', {
    defaultMessage: 'Visualization workspace'
  }))), props.workspacePanel, /*#__PURE__*/_react.default.createElement("div", {
    className: "hide-for-sharing",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, props.suggestionsPanel)), /*#__PURE__*/_react.default.createElement("section", {
    css: [sidebarStyles(euiThemeContext), (0, _react2.css)`
                  flex-basis: 25%;
                  min-width: 358px;
                  max-width: 440px;
                  max-height: 100%;
                  ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
                    max-width: 100%;
                  }
                  ${isFullscreen && `flex: 1; max-width: none;`}
                `],
    className: "hide-for-sharing",
    "aria-labelledby": "configPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "configPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.lens.section.configPanelLabel', {
    defaultMessage: 'Config panel'
  }))), props.configPanel)))));
}
const sidebarStyles = euiThemeContext => (0, _react2.css)`
  margin: 0;
  flex: 1 0 18%;
  min-width: 304px;
  display: flex;
  flex-direction: column;
  position: relative;
  ${(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])} {
    min-height: 360px;
  }
`;