"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _types = require("../../types");
var _utils = require("../utils");
var _esql_column = require("../columns/esql_column");
var _metric = require("../columns/metric");
var _utils2 = require("./utils");
var _coloring = require("../coloring");
var _utils3 = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
const LENS_DEFAULT_LAYER_ID = 'layer_0';
function buildVisualizationState(config) {
  var _layer$metric$alignme, _layer$metric$alignme2;
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    accessor: ACCESSOR,
    size: layer.metric.size,
    titlePosition: (_layer$metric$alignme = layer.metric.alignments) === null || _layer$metric$alignme === void 0 ? void 0 : _layer$metric$alignme.labels,
    textAlign: (_layer$metric$alignme2 = layer.metric.alignments) === null || _layer$metric$alignme2 === void 0 ? void 0 : _layer$metric$alignme2.value,
    ...(layer.metric.apply_color_to && layer.metric.color ? {
      colorMode: layer.metric.apply_color_to === 'background' ? 'Background' : 'Labels',
      palette: (0, _coloring.fromColorByValueAPIToLensState)(layer.metric.color)
    } : {
      colorMode: 'None'
    })
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  if (visualization.accessor == null) {
    throw new Error('Metric accessor is missing in the visualization state');
  }
  const dataset = (0, _utils.buildDatasetState)(layer, adHocDataViews, references, adhocReferences, layerId);
  if (!dataset || dataset.type == null) {
    throw new Error('Unsupported dataset type');
  }
  const props = {
    ...(0, _utils.generateApiLayer)(layer),
    metric: (0, _utils3.isEsqlTableTypeDataset)(dataset) ? (0, _esql_column.getValueApiColumn)(visualization.accessor, layer) : (0, _utils.operationFromColumn)(visualization.accessor, layer)
  };
  if (props.metric) {
    if (visualization.size) {
      props.metric.size = visualization.size;
    }
    if (visualization.titlePosition || visualization.textAlign) {
      props.metric.alignments = {
        ...(visualization.titlePosition ? {
          labels: visualization.titlePosition
        } : {}),
        ...(visualization.textAlign ? {
          value: visualization.textAlign
        } : {})
      };
    }
    if (visualization.colorMode && visualization.colorMode !== 'None' && visualization.palette) {
      props.metric.apply_color_to = visualization.colorMode === 'Background' ? 'background' : 'value';
      const colorByValue = (0, _coloring.fromColorByValueLensStateToAPI)(visualization.palette);
      if ((colorByValue === null || colorByValue === void 0 ? void 0 : colorByValue.range) === 'absolute') {
        props.metric.color = colorByValue;
      }
    }
  }
  return {
    type: 'legacy_metric',
    dataset: dataset,
    ...props
  };
}
function buildFormBasedLayer(layer) {
  const columns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = (0, _utils.generateLayer)(_types.DEFAULT_LAYER_ID, layer);
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  (0, _utils.addLayerColumn)(defaultLayer, ACCESSOR, columns);
  return layers;
}
function getValueColumns(layer) {
  return [(0, _esql_column.getValueColumn)(ACCESSOR, layer.metric.column, 'number')];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils.buildReferences)({
    [LENS_DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: 'lnsLegacyMetric',
    ...(0, _utils2.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}
function fromLensStateToAPI(config) {
  var _ref, _ref2, _state$datasourceStat, _state$datasourceStat2, _state$datasourceStat3, _state$datasourceStat4, _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (_ref = (_ref2 = (_state$datasourceStat = (_state$datasourceStat2 = state.datasourceStates.formBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers) !== null && _state$datasourceStat !== void 0 ? _state$datasourceStat : (_state$datasourceStat3 = state.datasourceStates.textBased) === null || _state$datasourceStat3 === void 0 ? void 0 : _state$datasourceStat3.layers) !== null && _ref2 !== void 0 ? _ref2 : // @ts-expect-error unfortunately due to a migration bug, some existing SO might still have the old indexpattern DS state
  (_state$datasourceStat4 = state.datasourceStates.indexpattern) === null || _state$datasourceStat4 === void 0 ? void 0 : _state$datasourceStat4.layers) !== null && _ref !== void 0 ? _ref : [];
  const [layerId, layer] = Object.entries(layers)[0];
  const visualizationState = {
    ...(0, _utils2.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : LENS_DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
  return visualizationState;
}