"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BedrockRuntimeClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _clientBedrockRuntime = require("@aws-sdk/client-bedrock-runtime");
var _middlewareStack = require("@smithy/middleware-stack");
var _bedrock = require("../../utils/bedrock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BedrockRuntimeClient extends _clientBedrockRuntime.BedrockRuntimeClient {
  constructor({
    actionsClient,
    connectorId,
    ...fields
  }) {
    var _fields$streaming;
    super(fields !== null && fields !== void 0 ? fields : {});
    (0, _defineProperty2.default)(this, "middlewareStack", void 0);
    (0, _defineProperty2.default)(this, "streaming", void 0);
    (0, _defineProperty2.default)(this, "actionsClient", void 0);
    (0, _defineProperty2.default)(this, "connectorId", void 0);
    (0, _defineProperty2.default)(this, "telemetryMetadata", void 0);
    this.streaming = (_fields$streaming = fields.streaming) !== null && _fields$streaming !== void 0 ? _fields$streaming : true;
    this.actionsClient = actionsClient;
    this.connectorId = connectorId;
    this.telemetryMetadata = fields === null || fields === void 0 ? void 0 : fields.telemetryMetadata;
    // eliminate middleware steps that handle auth as Kibana connector handles auth
    this.middlewareStack = (0, _middlewareStack.constructStack)();
  }
  async send(command, optionsOrCb) {
    const options = typeof optionsOrCb !== 'function' ? optionsOrCb : {};
    if (command.input.messages) {
      // without this, our human + human messages do not work and result in error:
      // A conversation must alternate between user and assistant roles.
      command.input.messages = (0, _bedrock.prepareMessages)(command.input.messages);
    }
    const data = await this.actionsClient.execute({
      actionId: this.connectorId,
      params: {
        subAction: 'bedrockClientSend',
        subActionParams: {
          telemetryMetadata: this.telemetryMetadata,
          command,
          signal: options === null || options === void 0 ? void 0 : options.abortSignal
        }
      }
    });
    if (data.status === 'error') {
      throw new Error(`ActionsClient BedrockRuntimeClient: action result status is error: ${data === null || data === void 0 ? void 0 : data.message} - ${data === null || data === void 0 ? void 0 : data.serviceMessage}`);
    }
    return data.data;
  }
}
exports.BedrockRuntimeClient = BedrockRuntimeClient;