"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deprecatedPipelineBadge = exports.PipelineTable = void 0;
exports.deserializeFilterOptions = deserializeFilterOptions;
exports.serializeFilterOptions = serializeFilterOptions;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _queryString = _interopRequireWildcard(require("query-string"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const deprecatedPipelineBadge = exports.deprecatedPipelineBadge = {
  badge: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedBadgeLabel', {
    defaultMessage: 'Deprecated'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedBadgeTooltip', {
    defaultMessage: 'This pipeline is no longer supported and might be removed in a future release. Instead, use one of the other pipelines available or create a new one.'
  })
};
const deprecatedFilterLabel = _i18n.i18n.translate('xpack.ingestPipelines.list.table.deprecatedFilterLabel', {
  defaultMessage: 'Deprecated'
});
const managedFilterLabel = _i18n.i18n.translate('xpack.ingestPipelines.list.table.managedFilterLabel', {
  defaultMessage: 'Managed'
});
const defaultFilterOptions = [{
  key: 'managed',
  label: managedFilterLabel,
  'data-test-subj': 'managedFilter'
}, {
  key: 'deprecated',
  label: deprecatedFilterLabel,
  checked: 'off',
  'data-test-subj': 'deprecatedFilter'
}];
const PAGE_SIZE_OPTIONS = [10, 20, 50];
function serializeFilterOptions(options) {
  return options.reduce((list, option) => {
    var _option$checked;
    return {
      ...list,
      [option.key]: (_option$checked = option.checked) !== null && _option$checked !== void 0 ? _option$checked : 'unset'
    };
  }, {});
}
function deserializeFilterOptions(options) {
  return defaultFilterOptions.map(filter => {
    const filterKey = filter.key ? filter.key : '';
    return {
      // Ignore checked property when setting as we are going to handle that separately
      ...(0, _lodash.omit)(filter, ['checked']),
      ...(options[filterKey] === 'unset' ? {} : {
        checked: options[filterKey]
      })
    };
  });
}
function isDefaultFilterOptions(options) {
  return options.managed === 'unset' && options.deprecated === 'off';
}
const PipelineTable = ({
  pipelines,
  isLoading,
  onReloadClick,
  onEditPipelineClick,
  onClonePipelineClick,
  onDeletePipelineClick,
  openFlyout
}) => {
  const [queryText, setQueryText] = (0, _react.useState)('');
  const [filterOptions, setFilterOptions] = (0, _react.useState)(defaultFilterOptions);
  const {
    history
  } = (0, _shared_imports.useKibana)().services;
  const [selection, setSelection] = (0, _react.useState)([]);
  const filterButtonRef = (0, _react.useRef)(null);
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'ingestPipelines',
    initialPageSize: 10,
    initialSort: {
      field: 'name',
      direction: 'asc'
    },
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const filteredPipelines = (0, _react.useMemo)(() => {
    // Filter pipelines list by whatever the user entered in the search bar
    const pipelinesAfterSearch = (pipelines || []).filter(pipeline => {
      return pipeline.name.toLowerCase().includes(queryText.toLowerCase());
    });

    // Then filter those results down with the selected options from the filter dropdown
    return pipelinesAfterSearch.filter(pipeline => {
      var _filterOptions$find, _filterOptions$find2;
      const deprecatedFilter = (_filterOptions$find = filterOptions.find(({
        key
      }) => key === 'deprecated')) === null || _filterOptions$find === void 0 ? void 0 : _filterOptions$find.checked;
      const managedFilter = (_filterOptions$find2 = filterOptions.find(({
        key
      }) => key === 'managed')) === null || _filterOptions$find2 === void 0 ? void 0 : _filterOptions$find2.checked;
      return !(deprecatedFilter === 'off' && pipeline.deprecated || deprecatedFilter === 'on' && !pipeline.deprecated || managedFilter === 'off' && pipeline.isManaged || managedFilter === 'on' && !pipeline.isManaged);
    });
  }, [pipelines, filterOptions, queryText]);

  // This effect will run once only to update the initial state of the filters
  // and queryText based on whatever is set in the query params.
  (0, _react.useEffect)(() => {
    var _history$location;
    const {
      queryText: searchQuery,
      deprecated,
      managed
    } = _queryString.default.parse((history === null || history === void 0 ? void 0 : (_history$location = history.location) === null || _history$location === void 0 ? void 0 : _history$location.search) || '');
    if (searchQuery) {
      setQueryText(searchQuery);
    }
    if (deprecated && managed) {
      setFilterOptions(deserializeFilterOptions({
        deprecated,
        managed
      }));
    }
  }, [history]);
  (0, _react.useEffect)(() => {
    const serializedFilterOptions = serializeFilterOptions(filterOptions);
    const isQueryEmpty = (0, _lodash.isEmpty)(queryText);
    const isDefaultFilters = isDefaultFilterOptions(serializedFilterOptions);
    const isDefaultFilterConfiguration = isQueryEmpty && isDefaultFilters;
    if (!isDefaultFilterConfiguration) {
      const {
        pipeline
      } = (0, _queryString.parse)(location.search.substring(1));
      history.push({
        pathname: '',
        search: '?' + _queryString.default.stringify({
          ...(!isQueryEmpty ? {
            queryText
          } : {}),
          ...(!isDefaultFilters ? serializedFilterOptions : {}),
          ...(pipeline ? {
            pipeline
          } : {})
        }, {
          strict: false,
          arrayFormat: 'index'
        })
      });
    }
  }, [history, queryText, filterOptions]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
    // Return focus to the filter button when popover closes
    if (filterButtonRef.current) {
      var _filterButtonRef$curr, _filterButtonRef$curr2;
      (_filterButtonRef$curr = (_filterButtonRef$curr2 = filterButtonRef.current).focus) === null || _filterButtonRef$curr === void 0 ? void 0 : _filterButtonRef$curr.call(_filterButtonRef$curr2);
    }
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    buttonRef: filterButtonRef,
    "data-test-subj": "filtersDropdown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: filterOptions.filter(item => item.checked !== 'off').length,
    hasActiveFilters: !!filterOptions.find(item => item.checked === 'on'),
    numActiveFilters: filterOptions.filter(item => item.checked === 'on').length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.filtersButtonLabel', {
    defaultMessage: 'Filters'
  }));
  const tableProps = {
    itemId: 'name',
    'data-test-subj': 'pipelinesTable',
    sorting,
    selection: {
      onSelectionChange: setSelection
    },
    rowProps: () => ({
      'data-test-subj': 'pipelineTableRow'
    }),
    cellProps: (pipeline, column) => {
      const {
        field
      } = column;
      return {
        'data-test-subj': `pipelineTableRow-${field}`
      };
    },
    search: {
      query: queryText,
      onChange: ({
        queryText: searchText,
        error
      }) => {
        if (!error) {
          setQueryText(searchText);
        }
      },
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "deletePipelinesButton",
        onClick: () => onDeletePipelineClick(selection),
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.deletePipelinesButtonLabel",
        defaultMessage: "Delete {count, plural, one {pipeline} other {pipelines} }",
        values: {
          count: selection.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 13
        }
      })) : undefined,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        key: "reloadButton",
        iconType: "refresh",
        color: "success",
        "aria-label": "refresh button",
        "data-test-subj": "reloadButton",
        size: "m",
        display: "base",
        onClick: onReloadClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 9
        }
      })],
      box: {
        incremental: true,
        'data-test-subj': 'pipelineTableSearch'
      },
      filters: [{
        type: 'custom_component',
        component: () => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 287,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
            id: "popoverID",
            button: button,
            isOpen: isPopoverOpen,
            closePopover: closePopover,
            panelPaddingSize: "none",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 288,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
            allowExclusions: true,
            "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.list.table.filtersAriaLabel', {
              defaultMessage: 'Filters'
            }),
            options: filterOptions,
            onChange: setFilterOptions,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 295,
              columnNumber: 19
            }
          }, list => /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: 300
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 306,
              columnNumber: 32
            }
          }, list))));
        }
      }]
    },
    pagination: {
      initialPageSize: pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    },
    onTableChange,
    columns: [{
      width: '25%',
      field: 'name',
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "pipelineDetailsLink",
          onClick: () => openFlyout(name),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 330,
            columnNumber: 13
          }
        }, name);
      }
    }, {
      width: '100px',
      render: pipeline => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "xs",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 340,
            columnNumber: 13
          }
        }, pipeline.isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 342,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
          label: _i18n.i18n.translate('xpack.ingestPipelines.list.table.managedBadgeLabel', {
            defaultMessage: 'Managed'
          }),
          color: "hollow",
          size: "s",
          "data-test-subj": "isManagedBadge",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 343,
            columnNumber: 19
          }
        })), pipeline.deprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 354,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: deprecatedPipelineBadge.badgeTooltip,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 355,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
          label: deprecatedPipelineBadge.badge,
          color: "subdued",
          size: "s",
          "data-test-subj": "isDeprecatedBadge",
          tabIndex: 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 356,
            columnNumber: 21
          }
        }))));
      }
    }, {
      field: 'description',
      sortable: true,
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.descriptionColumnTitle', {
        defaultMessage: 'Description'
      })
    }, {
      width: '120px',
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.preprocessorsColumnTitle', {
        defaultMessage: 'Preprocessors'
      }),
      align: 'right',
      dataType: 'number',
      sortable: ({
        processors
      }) => processors.length,
      render: ({
        processors
      }) => processors.length
    }, {
      width: '120px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.actionColumnTitle",
        defaultMessage: "Actions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 390,
          columnNumber: 11
        }
      }),
      actions: [{
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionLabel', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionDescription', {
          defaultMessage: 'Edit this pipeline'
        }),
        type: 'icon',
        icon: 'pencil',
        onClick: ({
          name
        }) => onEditPipelineClick(name)
      }, {
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionLabel', {
          defaultMessage: 'Duplicate'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionDescription', {
          defaultMessage: 'Duplicate this pipeline'
        }),
        type: 'icon',
        icon: 'copy',
        onClick: ({
          name
        }) => onClonePipelineClick(name)
      }, {
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionDescription', {
          defaultMessage: 'Delete this pipeline'
        }),
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: pipeline => onDeletePipelineClick([pipeline])
      }]
    }],
    items: filteredPipelines,
    loading: isLoading
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({}, tableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 10
    }
  }));
};
exports.PipelineTable = PipelineTable;