"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelineFlyoutWithContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _locator = require("../../../locator");
var _constants = require("../../../../common/constants");
var _shared_imports = require("../../../shared_imports");
var _delete_modal = require("./delete_modal");
var _pipeline_flyout = require("./pipeline_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/ingest_pipeline_flyout_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IngestPipelineFlyoutWithContext = ({
  coreServices,
  services,
  ingestPipelineName,
  onClose,
  reload
}) => {
  const locator = services.share.url.locators.get(_locator.INGEST_PIPELINES_APP_LOCATOR);
  const createPipeline = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: _locator.INGEST_PIPELINES_PAGES.CREATE,
      pipelineId: name
    });
  }, [locator]);
  const editPipeline = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: _locator.INGEST_PIPELINES_PAGES.EDIT,
      pipelineId: name
    });
  }, [locator]);
  const clonePipeline = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: _locator.INGEST_PIPELINES_PAGES.CLONE,
      pipelineId: name
    });
  }, [locator]);
  const [pipelinesToDelete, setPipelinesToDelete] = (0, _react.useState)([]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, (0, _extends2.default)({}, coreServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.AuthorizationProvider, {
    privilegesEndpoint: `${_constants.API_BASE_PATH}/privileges/ingest_pipelines`,
    httpClient: coreServices.http,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaContextProvider, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_flyout.PipelineFlyout, {
    ingestPipeline: ingestPipelineName,
    onClose: onClose,
    onCreateClick: createPipeline,
    onEditClick: editPipeline,
    onCloneClick: clonePipeline,
    onDeleteClick: pipelines => setPipelinesToDelete(pipelines),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), (pipelinesToDelete === null || pipelinesToDelete === void 0 ? void 0 : pipelinesToDelete.length) > 0 ? /*#__PURE__*/_react.default.createElement(_delete_modal.PipelineDeleteModal, {
    callback: () => {
      onClose();
      reload();
      setPipelinesToDelete([]);
    },
    pipelinesToDelete: pipelinesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }) : null)));
};
exports.IngestPipelineFlyoutWithContext = IngestPipelineFlyoutWithContext;