"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Join = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/join.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  separator: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.joinForm.separatorFieldLabel', {
      defaultMessage: 'Separator'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.joinForm.separatorFieldHelpText', {
      defaultMessage: 'Separator character.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.joinForm.separatorRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  }
};
const Join = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.joinForm.fieldNameHelpText', {
      defaultMessage: 'Field containing array values to join.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.separator,
    component: _shared_imports.Field,
    path: "fields.separator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.Join = Join;