"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsInDiscoverCallout = MetricsInDiscoverCallout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _esqlComposer = require("@kbn/esql-composer");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_kibana = require("../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/metrics_in_discover_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const buttonLabel = _i18n.i18n.translate('xpack.infra.metricsExplorer.euiCallout.buttonLabel', {
  defaultMessage: 'View metrics in Discover'
});
const calloutTitle = _i18n.i18n.translate('xpack.infra.metricsExplorer.euiCallout.title', {
  defaultMessage: 'Try the new metrics experience in Discover'
});
const calloutContent = _i18n.i18n.translate('xpack.infra.metricsExplorer.euiCallout.content', {
  defaultMessage: 'See all metrics in one place, break them down by dimesions, run ES|QL queries, and fine-tune your view.'
});
const metricsInDiscoverCalloutStorageKey = 'infra.metricsInDiscoverCalloutDismissed';
function getEsqlQuery(metricsIndex) {
  return (0, _esqlComposer.timeseries)(metricsIndex).toString();
}
function MetricsInDiscoverCallout({
  timeRange
}) {
  var _services$share, _services$share$url$l;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [dismissedCallout, setDismissedCallout] = (0, _useLocalStorage.default)(metricsInDiscoverCalloutStorageKey, false);
  const discoverHref = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : (_services$share$url$l = _services$share.url.locators.get(_deeplinksAnalytics.DISCOVER_APP_LOCATOR)) === null || _services$share$url$l === void 0 ? void 0 : _services$share$url$l.useUrl({
    timeRange: {
      from: timeRange.from,
      to: timeRange.to
    },
    query: {
      esql: getEsqlQuery('metrics-*')
    }
  });
  if (dismissedCallout || !discoverHref) {
    return null;
  }
  function dismissCallout() {
    setDismissedCallout(true);
  }
  function handleViewInDiscoverClick() {
    services.telemetry.reportMetricsExplorerCalloutViewInDiscoverClicked({
      view: 'metrics_explorer'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "infraMetricsExplorerMetricsInDiscoverCallout",
    size: "m",
    announceOnMount: true,
    title: calloutTitle,
    iconType: "cheer",
    onDismiss: dismissCallout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, calloutContent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraMetricsExplorerMetricsInDiscoverCalloutButton",
    fill: true,
    href: discoverHref,
    onClickCapture: handleViewInDiscoverClick,
    "aria-label": buttonLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, buttonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
}