"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _aws_ec2_layout = require("./layouts/aws_ec2_layout");
var _aws_rds_layout = require("./layouts/aws_rds_layout");
var _aws_s3_layout = require("./layouts/aws_s3_layout");
var _aws_sqs_layout = require("./layouts/aws_sqs_layout");
var _pod_layout = require("./layouts/pod_layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Layout = ({
  inventoryItemType,
  ...layoutProps
}) => {
  switch (inventoryItemType) {
    case 'awsEC2':
      return /*#__PURE__*/_react.default.createElement(_aws_ec2_layout.AwsEC2Layout, (0, _extends2.default)({}, layoutProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 14
        }
      }));
    case 'awsRDS':
      return /*#__PURE__*/_react.default.createElement(_aws_rds_layout.AwsRDSLayout, (0, _extends2.default)({}, layoutProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 14
        }
      }));
    case 'awsS3':
      return /*#__PURE__*/_react.default.createElement(_aws_s3_layout.AwsS3Layout, (0, _extends2.default)({}, layoutProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 14
        }
      }));
    case 'awsSQS':
      return /*#__PURE__*/_react.default.createElement(_aws_sqs_layout.AwsSQSLayout, (0, _extends2.default)({}, layoutProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 14
        }
      }));
    case 'pod':
      return /*#__PURE__*/_react.default.createElement(_pod_layout.PodLayout, (0, _extends2.default)({}, layoutProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 14
        }
      }));
    default:
      throw new Error(`${inventoryItemType} is not supported.`);
  }
};
exports.Layout = Layout;