"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleInventorySwitcher = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _dropdown_button = require("../dropdown_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/waffle_inventory_switcher.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDisplayNameForType = type => {
  const inventoryModel = (0, _common.findInventoryModel)(type);
  return inventoryModel.displayName;
};
const WaffleInventorySwitcher = () => {
  const {
    changeNodeType,
    changeGroupBy,
    changeMetric,
    changeAccount,
    changeRegion,
    changeCustomMetrics,
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const goToNodeType = (0, _react.useCallback)(targetNodeType => {
    closePopover();
    changeNodeType(targetNodeType);
    changeGroupBy([]);
    changeCustomMetrics([]);
    changeAccount('');
    changeRegion('');
    const inventoryModel = (0, _common.findInventoryModel)(targetNodeType);
    changeMetric({
      type: inventoryModel.metrics.defaultSnapshot
    });
  }, [closePopover, changeNodeType, changeGroupBy, changeCustomMetrics, changeAccount, changeRegion, changeMetric]);
  const goToHost = (0, _react.useCallback)(() => goToNodeType('host'), [goToNodeType]);
  const goToK8 = (0, _react.useCallback)(() => goToNodeType('pod'), [goToNodeType]);
  const goToContainer = (0, _react.useCallback)(() => goToNodeType('container'), [goToNodeType]);
  const goToAwsEC2 = (0, _react.useCallback)(() => goToNodeType('awsEC2'), [goToNodeType]);
  const goToAwsS3 = (0, _react.useCallback)(() => goToNodeType('awsS3'), [goToNodeType]);
  const goToAwsRDS = (0, _react.useCallback)(() => goToNodeType('awsRDS'), [goToNodeType]);
  const goToAwsSQS = (0, _react.useCallback)(() => goToNodeType('awsSQS'), [goToNodeType]);
  const panels = (0, _react.useMemo)(() => [{
    id: 'firstPanel',
    items: [{
      'data-test-subj': 'goToHost',
      name: getDisplayNameForType('host'),
      onClick: goToHost
    }, {
      'data-test-subj': 'goToPods',
      name: getDisplayNameForType('pod'),
      onClick: goToK8
    }, {
      'data-test-subj': 'goToContainer',
      name: getDisplayNameForType('container'),
      onClick: goToContainer
    }, {
      name: 'AWS',
      panel: 'awsPanel',
      'data-test-subj': 'goToAWS-open'
    }]
  }, {
    id: 'awsPanel',
    title: 'AWS',
    items: [{
      name: getDisplayNameForType('awsEC2'),
      onClick: goToAwsEC2,
      'data-test-subj': 'goToAWS-EC2'
    }, {
      name: getDisplayNameForType('awsS3'),
      onClick: goToAwsS3,
      'data-test-subj': 'goToAWS-S3'
    }, {
      name: getDisplayNameForType('awsRDS'),
      onClick: goToAwsRDS,
      'data-test-subj': 'goToAWS-RDS'
    }, {
      name: getDisplayNameForType('awsSQS'),
      onClick: goToAwsSQS,
      'data-test-subj': 'goToAWS-SQS'
    }]
  }], [goToAwsEC2, goToAwsRDS, goToAwsS3, goToAwsSQS, goToContainer, goToHost, goToK8]);
  const selectedText = (0, _react.useMemo)(() => {
    return getDisplayNameForType(nodeType);
  }, [nodeType]);
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    "data-test-subj": 'openInventorySwitcher',
    onClick: togglePopover,
    label: _i18n.i18n.translate('xpack.infra.waffle.showLabel', {
      defaultMessage: 'Show'
    }),
    showKubernetesInfo: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, selectedText);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenu",
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "firstPanel",
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }));
};
exports.WaffleInventorySwitcher = WaffleInventorySwitcher;