"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleGroupByControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _reactHooks = require("@kbn/react-hooks");
var _custom_field_panel = require("./custom_field_panel");
var _dropdown_button = require("../dropdown_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/waffle_group_by_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const maxGroupByTooltip = _i18n.i18n.translate('xpack.infra.waffle.maxGroupByTooltip', {
  defaultMessage: 'Only two groupings can be selected at a time'
});
const WaffleGroupByControls = ({
  options,
  nodeType,
  groupBy,
  onChange,
  onChangeCustomOptions,
  customOptions
}) => {
  const [isPopoverOpen, {
    toggle: togglePopover,
    off: closePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const combinedOptions = [...options, ...customOptions.map(option => ({
    ...option,
    toolTipContent: option.text
  }))];
  if (!combinedOptions.length) {
    throw Error(_i18n.i18n.translate('xpack.infra.waffle.unableToSelectGroupErrorMessage', {
      defaultMessage: 'Unable to select group by options for {nodeType}',
      values: {
        nodeType
      }
    }));
  }
  const handleRemove = field => {
    onChange(groupBy.filter(g => g.field !== field));
    onChangeCustomOptions(customOptions.filter(g => g.field !== field));
    // We need to close the panel after we rmeove the pill icon otherwise
    // it will remain open because the click is still captured by the EuiFilterButton
    setTimeout(() => closePopover());
  };
  const handleCustomField = field => {
    onChangeCustomOptions([...customOptions, {
      text: field,
      field
    }]);
    const fn = handleClick(field);
    fn();
  };
  const handleClick = field => () => {
    if (groupBy.some(g => g.field === field)) {
      handleRemove(field);
    } else if (groupBy.length < 2) {
      onChange([...groupBy, {
        field
      }]);
    }
    closePopover();
  };
  const isMaxGroupingsSelected = groupBy.length >= 2;
  const panels = [{
    id: 'firstPanel',
    title: _i18n.i18n.translate('xpack.infra.waffle.selectTwoGroupingsTitle', {
      defaultMessage: 'Select up to two groupings'
    }),
    items: [{
      name: _i18n.i18n.translate('xpack.infra.waffle.customGroupByOptionName', {
        defaultMessage: 'Custom field'
      }),
      disabled: isMaxGroupingsSelected,
      toolTipContent: isMaxGroupingsSelected ? maxGroupByTooltip : null,
      icon: 'empty',
      panel: 'customPanel'
    }, ...combinedOptions.map(o => {
      const icon = groupBy.some(g => g.field === o.field) ? 'check' : 'empty';
      const panel = {
        name: o.text,
        onClick: handleClick(o.field),
        icon
      };
      if (o.toolTipContent) {
        panel.toolTipContent = o.toolTipContent;
      }
      if (isMaxGroupingsSelected && icon === 'empty') {
        panel.toolTipContent = maxGroupByTooltip;
        panel.disabled = true;
      }
      return panel;
    })]
  }, {
    id: 'customPanel',
    title: _i18n.i18n.translate('xpack.infra.waffle.customGroupByPanelTitle', {
      defaultMessage: 'Group By Custom Field'
    }),
    width: 685,
    content: /*#__PURE__*/_react.default.createElement(_custom_field_panel.CustomFieldPanel, {
      currentOptions: customOptions,
      onSubmit: handleCustomField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 16
      }
    })
  }];
  const buttonBody = groupBy.length > 0 ? groupBy.map(g => combinedOptions.find(o => o.field === g.field)).filter(o => o != null)
  // In this map the `o && o.field` is totally unnecessary but Typescript is
  // too stupid to realize that the filter above prevents the next map from being null
  .map(o => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: o && o.field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, o && o.text)) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.groupByAllTitle",
    defaultMessage: "All",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  });
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    label: _i18n.i18n.translate('xpack.infra.waffle.groupByLabel', {
      defaultMessage: 'Group by'
    }),
    onClick: togglePopover,
    "data-test-subj": "waffleGroupByDropdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, buttonBody);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    id: "groupByPanel",
    button: button,
    panelPaddingSize: "none",
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    css: (0, _react2.css)`
          width: 320px;
          & .euiContextMenuItem__text {
            overflow: hidden;
            text-overflow: ellipsis;
          }
        `,
    initialPanelId: "firstPanel",
    panels: panels,
    "data-test-subj": "groupByContextMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
};
exports.WaffleGroupByControls = WaffleGroupByControls;