"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedViewsToolbarControls = SavedViewsToolbarControls;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHooks = require("@kbn/react-hooks");
var _manage_views_flyout = require("./manage_views_flyout");
var _upsert_modal = require("./upsert_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/saved_views/toolbar_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SavedViewsToolbarControls(props) {
  const {
    currentView,
    views,
    isFetchingViews,
    isFetchingCurrentView,
    isCreatingView,
    isUpdatingView,
    onCreateView,
    onDeleteView,
    onUpdateView,
    onLoadViews,
    onSetDefaultView,
    onSwitchView,
    viewState
  } = props;
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const [isManageFlyoutOpen, {
    on: openManageFlyout,
    off: closeManageFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const [isCreateModalOpen, {
    on: openCreateModal,
    off: closeCreateModal
  }] = (0, _reactHooks.useBoolean)(false);
  const [isUpdateModalOpen, {
    on: openUpdateModal,
    off: closeUpdateModal
  }] = (0, _reactHooks.useBoolean)(false);
  const togglePopoverAndLoad = () => {
    if (!isPopoverOpen) {
      onLoadViews();
    }
    togglePopover();
  };
  const goToManageViews = () => {
    closePopover();
    openManageFlyout();
  };
  const goToCreateView = () => {
    closePopover();
    openCreateModal();
  };
  const goToUpdateView = () => {
    closePopover();
    openUpdateModal();
  };
  const handleCreateView = (name, shouldIncludeTime = false) => {
    const attributes = {
      ...viewState,
      name
    };
    if (!shouldIncludeTime) {
      delete attributes.time;
    }
    onCreateView(attributes).then(closeCreateModal);
  };
  const handleUpdateView = (name, shouldIncludeTime = false) => {
    if (!currentView) return;
    const attributes = {
      ...viewState,
      name
    };
    if (!shouldIncludeTime) {
      delete attributes.time;
    }
    onUpdateView({
      id: currentView.id,
      attributes
    }).then(closeUpdateModal);
  };
  const openPopoverButtonRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "savedViews-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: togglePopoverAndLoad,
      "data-test-subj": "savedViews-openPopover",
      buttonRef: openPopoverButtonRef,
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      isLoading: isFetchingCurrentView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, currentView ? currentView.attributes.name : _i18n.i18n.translate('xpack.infra.savedView.unknownView', {
      defaultMessage: 'No view selected'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-manageViews",
    iconType: "indexSettings",
    onClick: goToManageViews,
    label: _i18n.i18n.translate('xpack.infra.savedView.manageViews', {
      defaultMessage: 'Manage views'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-updateView",
    iconType: "refresh",
    onClick: goToUpdateView,
    isDisabled: !currentView || currentView.attributes.isStatic,
    label: _i18n.i18n.translate('xpack.infra.savedView.updateView', {
      defaultMessage: 'Update view'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-saveNewView",
    iconType: "save",
    onClick: goToCreateView,
    label: _i18n.i18n.translate('xpack.infra.savedView.saveNewView', {
      defaultMessage: 'Save new view'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }))), isCreateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isSaving: isCreatingView,
    onClose: closeCreateModal,
    onSave: handleCreateView,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Save View",
      id: "xpack.infra.waffle.savedView.createHeader",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), isUpdateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isSaving: isUpdatingView,
    onClose: closeUpdateModal,
    onSave: handleUpdateView,
    initialName: currentView === null || currentView === void 0 ? void 0 : currentView.attributes.name,
    initialIncludeTime: Boolean(currentView === null || currentView === void 0 ? void 0 : currentView.attributes.time),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Update View",
      id: "xpack.infra.waffle.savedView.updateHeader",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }), isManageFlyoutOpen && /*#__PURE__*/_react.default.createElement(_manage_views_flyout.ManageViewsFlyout, {
    triggerRef: openPopoverButtonRef,
    loading: isFetchingViews,
    views: views,
    onMakeDefaultView: onSetDefaultView,
    onDeleteView: onDeleteView,
    onClose: closeManageFlyout,
    onSwitchView: onSwitchView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }));
}