"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.knownModels = exports.getModelDefinition = void 0;
var _model_provider = require("../model_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve a model definition from the given full model name, if available.
 */
const getModelDefinition = fullModelName => {
  return knownModels.find(model => fullModelName.includes(model.id) || fullModelName.includes(model.id.replaceAll('.', '-')));
};

/**
 * List of manually maintained model definitions to use as fallback for feature detection.
 */
exports.getModelDefinition = getModelDefinition;
const knownModels = exports.knownModels = [{
  id: 'gpt-4o-mini',
  provider: _model_provider.ModelProvider.OpenAI,
  family: _model_provider.ModelFamily.GPT,
  contextWindow: 128000
}, {
  id: 'gpt-4o',
  provider: _model_provider.ModelProvider.OpenAI,
  family: _model_provider.ModelFamily.GPT,
  contextWindow: 128000
}, {
  id: 'gpt-4.1-mini',
  provider: _model_provider.ModelProvider.OpenAI,
  family: _model_provider.ModelFamily.GPT,
  contextWindow: 1000000
}, {
  id: 'gpt-4.1-nano',
  provider: _model_provider.ModelProvider.OpenAI,
  family: _model_provider.ModelFamily.GPT,
  contextWindow: 1000000
}, {
  id: 'gpt-4.1',
  provider: _model_provider.ModelProvider.OpenAI,
  family: _model_provider.ModelFamily.GPT,
  contextWindow: 1000000
}, {
  id: 'gemini-1.5-pro',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 1000000
}, {
  id: 'gemini-1.5-flash',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 1000000
}, {
  id: 'gemini-2.0-flash',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 1000000
}, {
  id: 'gemini-2.0-pro',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 2000000
}, {
  id: 'gemini-2.0-flash-lite',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 1000000
}, {
  id: 'gemini-2.5-pro',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 1000000
}, {
  id: 'gemini-2.5-flash',
  provider: _model_provider.ModelProvider.Google,
  family: _model_provider.ModelFamily.Gemini,
  contextWindow: 128000 // or 1000000 in MAX mode...
},
// Claude models
{
  id: 'claude-3-sonnet',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-3-haiku',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-3-opus',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-3.5-sonnet',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-3.5-haiku',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-3.7-sonnet',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-4-sonnet',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}, {
  id: 'claude-4-opus',
  provider: _model_provider.ModelProvider.Anthropic,
  family: _model_provider.ModelFamily.Claude,
  contextWindow: 200000
}];