"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompletionType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lib = require("../../../../lib");
var _shared_imports = require("../../../../shared_imports");
var _field_parameters = require("../../field_parameters");
var _edit_field = require("../edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/field_types/completion_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultToggleValue = (param, field) => {
  switch (param) {
    case 'meta':
    case 'max_input_length':
      {
        return field[param] !== undefined && field[param] !== (0, _lib.getFieldConfig)(param).defaultValue;
      }
    case 'analyzers':
      {
        return field.search_analyzer !== undefined && field.search_analyzer !== field.analyzer;
      }
    default:
      return false;
  }
};
const CompletionType = ({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.AnalyzersParameter, {
    field: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.maxInputLengthFieldTitle', {
      defaultMessage: 'Set max input length'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.maxInputLengthFieldDescription', {
      defaultMessage: 'Limits the length of a single input.'
    }),
    defaultToggleValue: getDefaultToggleValue('max_input_length', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "max_input_length",
    config: (0, _lib.getFieldConfig)('max_input_length'),
    component: _shared_imports.Field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.preserveSeparatorsFieldTitle', {
      defaultMessage: 'Preserve separators'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.preserveSeparatorsFieldDescription', {
      defaultMessage: 'Preserves the separators.'
    }),
    formFieldPath: "preserve_separators",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.preservePositionIncrementsFieldTitle', {
      defaultMessage: 'Preserve position increments'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.completion.preservePositionIncrementsFieldDescription', {
      defaultMessage: 'Enables position increments.'
    }),
    formFieldPath: "preserve_position_increments",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.MetaParameter, {
    defaultToggleValue: getDefaultToggleValue('meta', field.source),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.CompletionType = CompletionType;