"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceOptionLabels = exports.sourceOptionDescriptions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceOptionLabels = exports.sourceOptionLabels = {
  [_constants.STORED_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.storedSourceFieldsLabel', {
    defaultMessage: 'Stored _source'
  }),
  [_constants.DISABLED_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.disabledSourceFieldsLabel', {
    defaultMessage: 'Disabled _source'
  }),
  [_constants.SYNTHETIC_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.syntheticSourceFieldsLabel', {
    defaultMessage: 'Synthetic _source'
  })
};
const sourceOptionDescriptions = exports.sourceOptionDescriptions = {
  [_constants.STORED_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.storedSourceFieldsDescription', {
    defaultMessage: 'Stores content in _source field for future retrieval'
  }),
  [_constants.DISABLED_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.disabledSourceFieldsDescription', {
    defaultMessage: 'Strongly discouraged, will impact downstream functionality'
  }),
  [_constants.SYNTHETIC_SOURCE_OPTION]: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.syntheticSourceFieldsDescription', {
    defaultMessage: 'Reconstructs source content to save on disk usage'
  })
};