"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _shared_imports = require("../shared_imports");
var _constants = require("../constants");
var _component_templates_context = require("../component_templates_context");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_list/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const inUseFilterLabel = _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.inUseFilterLabel', {
  defaultMessage: 'In use'
});
const managedFilterLabel = _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.managedFilterLabel', {
  defaultMessage: 'Managed'
});
const deprecatedFilterLabel = _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.deprecatedFilterLabel', {
  defaultMessage: 'Deprecated'
});
const PAGE_SIZE_OPTIONS = [10, 20, 50];
const ComponentTable = ({
  componentTemplates,
  defaultFilter,
  onReloadClick,
  onDeleteClick,
  onEditClick,
  onCloneClick,
  history
}) => {
  const {
    trackMetric
  } = (0, _component_templates_context.useComponentTemplatesContext)();

  // By default, we want to show all the component templates that are not deprecated.
  const [filterOptions, setFilterOptions] = (0, _react.useState)([{
    key: 'inUse',
    label: inUseFilterLabel,
    'data-test-subj': 'componentTemplates--inUseFilter'
  }, {
    key: 'managed',
    label: managedFilterLabel,
    'data-test-subj': 'componentTemplates--managedFilter'
  }, {
    key: 'deprecated',
    label: deprecatedFilterLabel,
    'data-test-subj': 'componentTemplates--deprecatedFilter',
    checked: 'off'
  }]);
  const [selection, setSelection] = (0, _react.useState)([]);
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'componentTemplates',
    initialPageSize: 10,
    initialSort: {
      field: 'name',
      direction: 'asc'
    },
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const filteredComponentTemplates = (0, _react.useMemo)(() => {
    var _filterOptions$find, _filterOptions$find2, _filterOptions$find3;
    const inUseFilter = (_filterOptions$find = filterOptions.find(({
      key
    }) => key === 'inUse')) === null || _filterOptions$find === void 0 ? void 0 : _filterOptions$find.checked;
    const managedFilter = (_filterOptions$find2 = filterOptions.find(({
      key
    }) => key === 'managed')) === null || _filterOptions$find2 === void 0 ? void 0 : _filterOptions$find2.checked;
    const deprecatedFilter = (_filterOptions$find3 = filterOptions.find(({
      key
    }) => key === 'deprecated')) === null || _filterOptions$find3 === void 0 ? void 0 : _filterOptions$find3.checked;
    return (componentTemplates || []).filter(component => {
      return !(deprecatedFilter === 'off' && component.isDeprecated || deprecatedFilter === 'on' && !component.isDeprecated || managedFilter === 'off' && component.isManaged || managedFilter === 'on' && !component.isManaged || inUseFilter === 'off' && component.usedBy.length >= 1 || inUseFilter === 'on' && component.usedBy.length === 0);
    });
  }, [componentTemplates, filterOptions]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "componentTemplatesFiltersButton",
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: filterOptions.filter(item => item.checked !== 'off').length,
    hasActiveFilters: !!filterOptions.find(item => item.checked === 'on'),
    numActiveFilters: filterOptions.filter(item => item.checked === 'on').length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.filtersButtonLabel', {
    defaultMessage: 'Filters'
  }));
  const tableProps = {
    tableLayout: 'auto',
    itemId: 'name',
    'data-test-subj': 'componentTemplatesTable',
    sorting,
    selection: {
      onSelectionChange: setSelection,
      selectable: ({
        usedBy
      }) => usedBy.length === 0,
      selectableMessage: (selectable, {
        name
      }) => selectable ? _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.selectionLabel', {
        defaultMessage: 'Select "{name}" component template',
        values: {
          name
        }
      }) : _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.disabledSelectionLabel', {
        defaultMessage: 'Component template "{name}" is in use and cannot be deleted',
        values: {
          name
        }
      })
    },
    rowProps: () => ({
      'data-test-subj': 'componentTemplateTableRow'
    }),
    search: {
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "deleteComponentTemplatexButton",
        onClick: () => onDeleteClick(selection.map(({
          name
        }) => name)),
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesList.table.deleteComponentTemplatesButtonLabel",
        defaultMessage: "Delete {count, plural, one {component template} other {component templates} }",
        values: {
          count: selection.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      })) : undefined,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "reloadButton",
        iconType: "refresh",
        color: "success",
        "data-test-subj": "reloadButton",
        onClick: onReloadClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.reloadButtonLabel', {
        defaultMessage: 'Reload'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createComponentTemplateButton",
        key: "createComponentTemplateButton"
      }, (0, _shared_imports.reactRouterNavigate)(history, '/create_component_template'), {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 9
        }
      }), _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.createButtonLabel', {
        defaultMessage: 'Create component template'
      }))],
      box: {
        incremental: true,
        'data-test-subj': 'componentTemplatesSearch'
      },
      filters: [{
        type: 'custom_component',
        component: () => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 216,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
            button: button,
            isOpen: isPopoverOpen,
            closePopover: closePopover,
            panelPaddingSize: "none",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 217,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
            allowExclusions: true,
            "aria-label": _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.filtersAriaLabel', {
              defaultMessage: 'Filters'
            }),
            options: filterOptions,
            onChange: setFilterOptions,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 223,
              columnNumber: 19
            }
          }, list => /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: 300
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 234,
              columnNumber: 32
            }
          }, list))));
        }
      }],
      defaultQuery: defaultFilter
    },
    pagination: {
      initialPageSize: pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    },
    onTableChange,
    columns: [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      width: '45%',
      render: (name, item) => /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, {
        pathname: encodeURI(`/component_templates/${encodeURIComponent(name)}`)
      }, () => trackMetric(_analytics.METRIC_TYPE.CLICK, _constants.UIM_COMPONENT_TEMPLATE_DETAILS)), {
        role: "button",
        "data-test-subj": "templateDetailsLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 13
        }
      }), name), item.isDeprecated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_components.DeprecatedBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 17
        }
      })), item.isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "isManagedBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.managedBadgeLabel', {
        defaultMessage: 'Managed'
      }))))
    }, {
      field: 'usedBy',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.isInUseColumnTitle', {
        defaultMessage: 'Usage count'
      }),
      sortable: ({
        usedBy
      }) => usedBy.length,
      render: usedBy => {
        if (usedBy.length) {
          return usedBy.length;
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 303,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("i", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 304,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.componentTemplatesList.table.notInUseCellDescription",
          defaultMessage: "Not in use",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 305,
            columnNumber: 17
          }
        })));
      }
    }, {
      field: 'hasMappings',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.mappingsColumnTitle', {
        defaultMessage: 'Mappings'
      }),
      truncateText: true,
      align: 'center',
      sortable: true,
      render: hasMappings => hasMappings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 322,
          columnNumber: 58
        }
      }) : null
    }, {
      field: 'hasSettings',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.settingsColumnTitle', {
        defaultMessage: 'Settings'
      }),
      truncateText: true,
      align: 'center',
      sortable: true,
      render: hasSettings => hasSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 58
        }
      }) : null
    }, {
      field: 'hasAliases',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.aliasesColumnTitle', {
        defaultMessage: 'Aliases'
      }),
      truncateText: true,
      align: 'center',
      sortable: true,
      render: hasAliases => hasAliases ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 56
        }
      }) : null
    }, {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesList.table.actionColumnTitle",
        defaultMessage: "Actions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 346,
          columnNumber: 11
        }
      }),
      actions: [{
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionEditText', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionEditDecription', {
          defaultMessage: 'Edit this component template'
        }),
        onClick: ({
          name
        }) => onEditClick(name),
        isPrimary: true,
        icon: 'pencil',
        type: 'icon',
        'data-test-subj': 'editComponentTemplateButton'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionCloneText', {
          defaultMessage: 'Clone'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionCloneDecription', {
          defaultMessage: 'Clone this component template'
        }),
        onClick: ({
          name
        }) => onCloneClick(name),
        icon: 'copy',
        type: 'icon',
        'data-test-subj': 'cloneComponentTemplateButton'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.deleteActionDescription', {
          defaultMessage: 'Delete this component template'
        }),
        onClick: ({
          name
        }) => onDeleteClick([name]),
        enabled: ({
          usedBy
        }) => usedBy.length === 0,
        isPrimary: true,
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        'data-test-subj': 'deleteComponentTemplateButton'
      }]
    }],
    items: filteredComponentTemplates
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({}, tableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 10
    }
  }));
};
exports.ComponentTable = ComponentTable;