"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfiguration = exports.ConfigurationProvider = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/form/configuration_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfigurationContext = /*#__PURE__*/(0, _react.createContext)(null);
const pathToHotPhaseSearchableSnapshot = 'phases.hot.actions.searchable_snapshot.snapshot_repository';
const pathToColdPhaseSearchableSnapshot = 'phases.cold.actions.searchable_snapshot.snapshot_repository';
const ConfigurationProvider = ({
  children
}) => {
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [pathToHotPhaseSearchableSnapshot, pathToColdPhaseSearchableSnapshot, _constants.isUsingCustomRolloverPath, _constants.isUsingDefaultRolloverPath, (0, _constants.isUsingDownsamplePath)('hot'), (0, _constants.isUsingDownsamplePath)('warm'), (0, _constants.isUsingDownsamplePath)('cold')]
  });
  const isUsingDefaultRollover = (0, _lodash.get)(formData, _constants.isUsingDefaultRolloverPath);
  // Provide default value, as path may become undefined if removed from the DOM
  const isUsingCustomRollover = (0, _lodash.get)(formData, _constants.isUsingCustomRolloverPath, true);
  const context = {
    isUsingRollover: isUsingDefaultRollover === false ? isUsingCustomRollover : true,
    isUsingSearchableSnapshotInHotPhase: (0, _lodash.get)(formData, pathToHotPhaseSearchableSnapshot) != null,
    isUsingSearchableSnapshotInColdPhase: (0, _lodash.get)(formData, pathToColdPhaseSearchableSnapshot) != null,
    isUsingDownsampleInHotPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('hot')),
    isUsingDownsampleInWarmPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('warm')),
    isUsingDownsampleInColdPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('cold'))
  };
  return /*#__PURE__*/_react.default.createElement(ConfigurationContext.Provider, {
    value: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 10
    }
  }, children);
};
exports.ConfigurationProvider = ConfigurationProvider;
const useConfiguration = () => {
  const ctx = (0, _react.useContext)(ConfigurationContext);
  if (!ctx) throw new Error('Cannot use configuration outside of configuration context');
  return ctx;
};
exports.useConfiguration = useConfiguration;